<?php
$cegek = array(
	'aco' => array('name' => 'ACO', 'web' => 'https://www.aco.hu/', 'email' => 'acohu@aco.hu', 'facebook' => 'ACOgroup.hu', 'youtube' => '@aco.magyarorszag'),
	'anda' => array('name' => 'Anda Kft.', 'web' => ['https://www.anda.hu/', 'https://www.pava.hu/', 'https://www.hunor.co/'], 'email' => 'ertekesites@anda.hu', 'tel' => '+36 30 699 0200', 'facebook' => 'andafestek', 'instagram' => 'andafestek', 'brands' => ['hunor', 'pava']),
	'arturo' => array('name' => 'Arturo', 'parent' => 'uzin'),
	'aspectis' => array('name' => 'Aspectis Kft.', 'web' => 'https://aspectis.hu/'),
	'atlas' => array('name' => 'ATLAS Group', 'web' => ['https://atlas-romania.ro/hu', 'https://gel-technology.co.uk/'], 'email' => ['geza.galambos@cesal.ro', 'office@cesal.ro'], 'tel' => '+36 30 073 0326', 'facebook' => 'CESAL.RO', 'youtube' => '@CESALbyATLAS'),
	//'bauhaus'          => array('name' => 'Bau-Haus Kft.',          'web' => 'https://bau-haus.hu/', 'email' => 'ajanlatkeres@bau-haus.hu', 'tel' => '+36-23-332-119', 'facebook' => 'BAUHAUSKFT', 'instagram' => 'bauhauskft', 'linkedin' => 'company/bau-haus-kft/'),
	'barabasteglako' => array('name' => 'Barabás Téglakő Kft.', 'web' => 'https://www.barabasteglako.hu/', 'email' => 'info@barabasteglako.hu', 'tel' => '+36 30 010 9800', 'facebook' => 'barabasteglakokft', 'instagram' => 'barabas_teglako', 'youtube' => '@barabasteglako', 'tiktok' => '@barabasteglako'),
	'baumit' => array('name' => 'Baumit Kft.', 'web' => 'https://baumit.hu/', 'email' => 'baumit@baumit.hu', 'tel' => '+36 33 512 920', 'facebook' => 'BaumitHU', 'instagram' => 'baumit_hu', 'youtube' => 'user/BaumitHU'),
	'bautool' => array('name' => 'Bautool', 'parent' => 'merkbau'),
	'bezzegh' => array('name' => 'Bezzegh Épületgépészeti Kft.', 'web' => 'https://bezzeghkft.hu/', 'email' => 'bezzeghkft@bezzeghkft.hu', 'tel' => '+36 (37) 317 017', 'facebook' => 'bezzeghkft'),
	'bihui' => array('name' => 'Bihui', 'parent' => 'merkbau'),
	'blackndecker' => array('name' => 'Stanley Black & Decker', 'parent' => 'stanley'),
	'blum' => array('name' => 'Blum Hungária Kft.', 'web' => 'https://www.blum.com/hu/hu/', 'email' => 'info.hu@blum.com', 'tel' => '+36 27 510 140', 'facebook' => 'BlumMagyarorszag', 'instagram' => 'blum_group', 'youtube' => '@BlumFurniturefittings', 'linkedin' => 'company/blumgroup', ),
	'bosch' => array('name' => 'Robert Bosch', 'web' => 'https://www.bosch.hu/', 'email' => 'kapcsolat@hu.bosch.com', 'tel' => '+36 1 879 9889', 'facebook' => 'boschmagyarorszag', 'instagram' => 'boschhungary', 'youtube' => '@boschmagyarorszag', 'linkedin' => 'company/bosch-magyarorszag', ),
	'bostik' => array('name' => 'Bostik','web' => 'https://www.bostik.com/hungary/hu_HU/','tel' => '+36 30 833 33 00','email'=>'info.hu@bostik.com,','facebook'=>'BostikGroup','instagram' => 'bostikofficial  ', 'youtube' => '@boschmagyarorszag', 'linkedin' => 'cbostik ','X'=> 'bostik'),
	// 'botament'        => array('name' => 'Botament',             'web' => 'https://botament.hu/', 'email' => 'info@botament.hu', 'tel' => '+36 20 583 80 82'),
	'bramac_villas' => array('name' => 'BMI Magyarország Kft.', 'web' => 'https://www.bmigroup.com/hu/', 'email' => 'infohu@bmigroup.com', 'tel' => '(+36) 88 / 590-891', 'facebook' => 'bmimagyarorszag', 'instagram' => 'bmimagyarorszag', 'youtube' => '@BMIMagyarorszag', 'pinterest' => 'BMIMagyarorszag', 'tiktok' => '@bmi_magyarorszag'),
	//'braunbau'        => array('name' => 'Bau2Home ', 'web' => 'https://bau2home.hu/', 'email' => 'ertekesites@bau2home.hu', 'tel' => '+36 70 522 5908', 'facebook' => 'bau2home'),
	'butorvonal' => array('name' => 'Bútor Vonal', 'web' => 'https://butorvonal.hu/', 'email' => 'iroda@butorvonal.hu', 'tel' => '+36 30 843 4413', 'facebook' => 'ButorVonalKft', 'instagram' => 'butor_vonal','brands' => ['butorvonal','solaflex','hailo' ,'hettich','kessebohmer']),
	//'buzon'           => array('name' => 'Buzon',                'web' => 'https://www.buzon-world.com/', 'email' => 'bence.buzon@gmail.com', 'tel' => '+36 70 332 6540'),
	'cemix' => array('name' => 'Cemix Hungary Kft.', 'web' => 'https://www.cemix.hu/', 'email' => 'vevoszolgalat@cemix.hu', 'tel' => '+36 88 590 500', 'facebook' => '', 'instagram' => '', 'youtube' => ''),
	'ceresit' => array('name' => 'Ceresit', 'web' => ['https://www.ceresit.hu/'], 'email' => ['ceresit.hungary@henkel.com'], 'tel' => '', 'facebook' => 'ceresit', 'instagram' => 'ceresit_hungary', 'youtube' => 'channel/UCnmPHL92n4HQQAKAZh5EjJA','brands' => ['ceresit','henkel']),
	//'chromos'      	  => array('name' => 'Chromos-Svjetlost',					'web' => 'http://www.chromos.hu/', 'youtube' => 'playlist?list=PL3wu3n-j-SV2MdXBwJ7jjwsFTj2IorJ2n'),
	'codex' => array('name' => 'Codex', 'parent' => 'uzin'),
	//'collomix'        => array('name' => 'Collomix',             'web' => 'https://www.collomix.hu/', 'email' => 'info@stabparketta.hu', 'tel' => '+36 (30) 278-2201', 'facebook' => 'stab.parketta'),
//'citroen'         => array('name' => 'Citröen', 'hidden' => TRUE, 'stand' => ['no' => '62', 'size' => '16x6']),
//'peugeot'         => array('name' => 'Peugeot', 'hidden' => TRUE, 'stand' => ['no' => '62', 'size' => '16x6']),
	'diatech' => array('name' => 'Diatech', 'web' => 'https://www.diatech.hu/', 'email' => '', 'tel' => ''),
	'dinocoop' => array('name' => 'Dinocoop Kft.', 'web' => 'https://dinocoop.hu/', 'sales' => ['name' => 'Ottlakán Pálma', 'email' => 'pottlakan@dinocoop.hu', 'tel' => '+36 20 562 46 64'], 'facebook' => 'DinocoopKft', 'instagram' => 'dinocoopkft', 'youtube' => '@dinocoopkft5357', 'brands' => ['wagner', 'wolfcraft', 'steinel']),
	//'domotors'        => array('name' => 'Domotors Kft.',        'web' => 'https://munkavedelemshop.hu/', 'email' => 'shopbuda@starworkwear.hu', 'tel' => '+36 70 632 95 71', 'facebook' => 'munkavedelemshop', 'instagram' => 'munkavedelemshop'),
	'dufa' => array('name' => 'Düfa', 'web' => 'https://dufa-hungary.hu/', 'email' => 'info@meffert.hu', 'tel' => '+36 35 550 005', 'facebook' => 'dufahungary', 'instagram' => 'dufahungary'),
	//'egrokorr'        => array('name' => 'Egrokorr Festékipari Zrt.',             'web' => 'https://egrokorr.hu/', 'email' => 'egrokorr@egrokorr.hu', 'tel' => '+36 23 521 270', 'facebook' => 'egrokorr',),
	'eth' => array('name' => 'Euro-Tools Hungary Kft.', 'web' => 'http://eth.hu/', 'email' => 'info@eth.hu', 'tel' => '+36 30 301 33 30', 'facebook' => 'ethkft'),
	'exctools' => array('name' => 'EXC Tools', 'web' => 'https://www.facebook.com/p/EXC-Tools-100066572629211/', 'email' => '', 'tel' => '+36 30 436 8286'),
	'fatraizolfa' => array('name' => 'Fatra Izolfa', 'web' => 'https://www.fatrafloor.cz/hu/', 'sales' => ['name' => 'Jámbor Zsolt', 'email' => 'fatra@izolfa.com', 'tel' => '+36-30-883-6997'], 'facebook' => 'fatraizolfaHU', 'instagram' => 'fatra_izolfa_hungary', 'youtube' => '@fatraizolfahungary7348'),
	'festatools' => array('name' => 'FESTA', 'web' => 'https://www.festatools.hu/hu', 'email' => 'festatools@festatools.hu', 'facebook' => 'festatool', 'instagram' => 'festatools', 'youtube' => '@festa-profesionalninaradix5534'),
	'festool' => array('name' => 'Festool', 'web' => 'https://www.festool.hu/', 'email' => 'customerservice@festool.hu', 'tel' => '+36-1-297-1350', 'facebook' => 'FestoolHU', 'tiktok' => '@festool.hu', 'linkedin' => 'company/festool-hu-tooltechnic-system-kft'),
	'happyfloor' => array('name' => 'HappyFloor', 'web' => 'https://happyfloor.hu/', 'email' => 'happyfloor@stefinox.hu', 'tel' => '+36 70 941 4041', 'facebook' => 'happyfloorhungary', 'linkedin' => 'company/happy-floor', 'youtube' => '@happyfloor-easydekideiglen2627'),
	'helios' => array('name' => 'HELIOS', 'web' => ['https://www.helios-deco.com/hu', 'https://www.belinka.com/hu/'], 'email' => 'heliosmegrendeles@anda.hu', 'tel' => '+36 30 011 1144', 'facebook' => 'belinka.si', 'instagram' => 'belinka.si', 'youtube' => '@kansaiheliosgroup9500', 'brands' => ['helios', 'kemostik', 'zvezda', 'belinka', 'chromos']),
	'belinka' => array('name' => 'Belinka', 'web' => 'https://www.belinka.com/hu/', 'email' => 'info@belinka.com', 'tel' => '+36 30 123 4567', 'facebook' => 'belinkahungary', 'instagram' => 'belinkahungary', 'youtube' => '@belinkahungary','parent' => 'helios'),
	'henkel' => array('name' => 'Henkel', 'parent' => 'ceresit'),
	'hikoki' => array('name' => 'HIKOKI', 'web' => 'https://hikoki-powertools.hu/', 'email' => '', 'tel' => '', 'facebook' => 'hikokipowertoolshungary', 'instagram' => 'hikokipowertoolshungary', 'youtube' => 'channel/UCn0gyJYj8N9ySlAN-WFLjMg'),
	'horvathtrade' => array('name' => 'Horvath Trade Holding Kft.', 'web' => 'https://horvathtrade.hu/', 'email' => 'info@horvathtrade.hu', ),
	'hunor' => array('name' => 'Hunor', 'parent' => 'anda'),
	//'husqvarna'       => array('name' => 'Husqvarna Magyarország Kft.', 'web' => 'https://www.husqvarna.com/hu/', 'email' => 'vevoszolgalat.husqvarna@husqvarnagroup.com', 'tel' => '+36-1-251-4161', 'facebook' => 'Husqvarna.Hungary', 'instagram' => 'husqvarnaworldwide', 'youtube' => '@husqvarna'),
//'innopan'         => array('name' => 'InnoPan TECH Kft.',   'web' => 'https://innopan.hu/', 'email' => 'info@innopan.hu', 'tel' => '+36 30 163 4694', 'facebook' => 'innopanszigeteles', 'instagram' => 'innopantech', 'linkedin' => 'company/innopan', 'youtube' => '@innopan5152'),
	'isover' => array('name' => 'Isover Saint-Gobain'), //'web' => 'https://www.isover.hu/', 'email' => 'isover@isover.hu', 'facebook' => 'isoverhungary', 'instagram' => 'saintgobainhungary', 'pinterest' => 'saintgobainnews'),
	//'jika'            => array('name' => 'Jika',                 'web' => 'https://www.jika.hu/', 'email' => 'akos.nemeth@hu.laufen.com', 'tel' => '+36 30 699 57 75', 'facebook' => '', 'instagram' => 'Jika.hungary', 'youtube' => ''),
//'kallofem'        => array('name' => 'KÁLLÓ-fém',            'web' => 'https://kallofem.hu', 'email' => 'titkarsag@kallofem.hu',  'tel' => '+36 42 264 185', 'facebook' => 'kallofem', 	 'pinterest' => 'kallofem', 'youtube' => '@kallo-femkft.-hivatalos2500'),
	'kapriol' => array('name' => 'Kapriol', 'web' => 'https://kapriol.hu/', 'email' => 'info@kapriol.hu', 'tel' => '+36 20 280 6894', 'facebook' => 'Kapriol.hu', 'instagram' => 'kapriol_official', 'youtube' => '@Kapriol1927'),
	//'kiralyhazak'     => array('name' => 'Királyházak',          'web' => 'https://kiralyhazak.hu', 'email' => 'kiralyhazak@kiralyhazak.hu',  'tel' => '+36 30 932 1135', 'facebook' => 'kiralyhazak', 'youtube' => 'channel/UC1rzwEkRwhBCSyiZiVW2cBQ', 'linkedin' => 'company/kiralyhazak', 'instagram' => 'kiralyhazak.ecohazak'),
'klimaexpress'    	 => array('name' => 'KLÍMA-EXPRESS Kft.',          'web' => ['https://www.munkaruha-munkacipo.hu', 'https://www.klimaexpress.hu'], 'email' => ['info@munkaruha-munkacipo.hu', 'klimaexpress@klimaexpress.hu'],  'tel' => '+36 1 260 3950', 'facebook' => 'professzionalismunkaruha', 'youtube' => '@klimaexpresskft.professzio520',  'instagram' => 'professzionalis_munkaruha'),
//'knauf'   		  => array('name' => 'Knauf Építőipari Kft.', 'web' => 'https://knauf.hu/', 'email' => 'info-hu@knauf.com', 'tel' => '+36 1 248 2430', 'facebook' => 'knaufmagyarorszag', 'instagram' => 'knaufmagyarorszag', 'youtube' => '@knaufmagyarorszag1439',  'brands' => ['knaufinsulation', 'cemix']),
//'knaufceiling'    => array('name' => 'Knauf Ceiling Solutions', 'web' => 'https://www.knaufceilingsolutions.com/hu/', 'linkedin' => 'company/knauf-ceiling-solutions', 'instagram' => 'knaufceilingsolutions', 'youtube' => '@KnaufCeilingSolutions'),
//'knaufinsulation' => array('name' => 'Knauf Insulation Kft.', 'web' => 'https://www.knaufinsulation.hu/', 'email' => 'info.hu@knaufinsulation.com', 'tel' => '+36 23 889 844', 'facebook' => 'KnaufInsulationHUN', 'youtube' => '@knaufinsulation-hu', 'pdf' => ['Ásvány- és fagyapot termékek (15MB)']),
//'kohazy'          => array('name' => 'Kőházy Tradíció Kft.', 'web' => 'https://www.kohazy.hu/', 'email' => 'info@kohazy.hu', 'tel' => ['06-1-329-8420', '06-1-288-0818', '06-1-350-7759'], 'facebook' => 'kohazyfestek'),
	'krause' => array('name' => 'KRAUSE-Systems', 'web' => 'https://www.krause-systems.hu/', 'email' => 'info@krause-systems.hu', 'tel' => '+36 23 521 130', 'facebook' => 'people/KRAUSE-Magyarorsz%C3%A1g/100057524864895', 'instagram' => 'krausehungary', 'linkedin' => 'company/krause-magyarorszag'),
	'krdesign' => array('name' => 'KR Design','web'=>'http://www.krdesignkft.hu/','tel'=>'+36704145533','email'=>'krdesignkft@gmail.com','facebook'=>'KR-Design-Kft'),
	'kubala' => array('name' => 'Kubala', 'web' => 'http://eth.hu/', 'email' => 'info@eth.hu', 'tel' => '+36 30 301 33 30', 'facebook' => 'kubalatoolshungary'),
	//'kvarc'           => array('name' => 'Kvarc építőanyagok',   'web' => 'https://www.kvarc.hu/', 'email' => 'info@kvarcasvany.hu', 'tel' => '+36 87 471 085', 'facebook' => 'kvarcepitoanyagok', 'instagram' => 'kvarcepitoanyagok', 'youtube' => '@kvarc-asvanykft.'),
	'lajter' => array('name' => 'Lajter-Bútor Kft.', 'web' => 'https://www.lajter.hu/', 'email' => ' info@lajter.hu', 'tel' => '+36 70 636 66 26', 'facebook' => 'butoralapanyagok', 'instagram' => 'lajterbutor', 'youtube' => '@lajterezermester9693', 'tiktok' => 'lajter.butor'),
	'lappfa' => array('name' => 'Lapp-fa', 'web' => 'https://lappfa.hu/', 'email' => 'webshop@lapp-fa.hu','facebook'=>'LAPPFA'),
	'laufen' => array('name' => 'Laufen', 'web' => 'https://www.laufen.hu/', 'email' => 'akos.nemeth@hu.laufen.com', 'tel' => '+36 30 699 57 75', 'facebook' => '', 'instagram' => 'Laufen_Hungary', 'youtube' => ''),
	//'leicon'          => array('name' => 'leiCON Hungary Kft.',  'web' => 'https://leicon.hu/', 'email' => 'info@leiconhungary.com',  'facebook' => 'leiconhungary', 'youtube' => '@leiconhungary', 'linkedin' => 'company/leicon-hungary'),
	'leier' => array('name' => 'Leier Hungária Kft.', 'web' => 'https://www.leier.hu/hu', 'email' => 'kpertekesites@leier.hu', 'tel' => '+36 96 512 000', 'facebook' => 'LeierHU', 'instagram' => 'leier_hu', 'youtube' => 'channel/UCLR08oEtcauVlyUbwyPBctQ'),
	//'greewer'         => array('name' => 'Greewer',  'parent' => 'wattbolt'),
	'mapei' => array('name' => 'Mapei', 'web' => 'https://www.mapei.com/hu', 'email' => '', 'tel' => '+36 23 501 670', 'facebook' => 'mapeihungary', 'instagram' => 'mapeihungary', 'youtube' => 'mapeihungary'),
	//'matrixoktatas' => array('name' => 'Mátrix Oktatási Központ', 'web' => 'https://www.matrixoktatas.hu/', 'email' => 'info@matrixoktatas.hu', 'tel' => '+36 70 424 23 30', 'facebook' => 'matrixoktatas', 'instagram' => 'matrixoktatasikozpont', 'tiktok' => '@matrixszakkepzo', 'youtube' => '@MatrixOktatasiKozpont'),
	'meffert' => array('name' => 'Meffert Hungária Kft.', 'parent' => 'dufa'),
	'merkbau' => array('name' => 'Merkbau', 'web' => 'https://bautoolshop.hu/', 'email' => 'szerszam@merkbau.hu', 'tel' => '+36 77 521 311', 'brands' => ['bihui', 'bautool']),
	'mester' => array('name' => 'Mester', 'web' => 'https://www.mester.hu/25-eves-mester', 'email' => 'optima@optimaforma.hu', 'tel' => '+36 1 430 30 90', 'facebook' => 'MesterOptima', 'youtube' => 'channel/UCPnvnaNipVhf1c6K50zfW2w'),
	//'metabo'          => array('name' => 'Metabo',               'web' => 'https://www.metabo.com/hu/hu/', 'email' => 'info@metabo.hu', 'tel' => '+36 1 434-22-25', 'facebook' => 'metabo', 'instagram' => 'metabo_magyarorszag', 'youtube' => 'playlist?list=PLVv94AEzWYYpABxs-yZf5THAk0ZJ6YJOY'),
//'metalsheet'      => array('name' => 'Metal-Sheet Kft.',     'web' => 'https://www.metal-sheet.hu/', 'email' => 'marketing@metal-sheet.hu', 'tel' => '+36 30 572 3149', 'facebook' => 'metalsheetkft'),
	'meton' => array('name' => 'METON', 'web' => 'https://meton.hu/', 'email' => 'meton@meton.hu', 'tel' => '+36 29 562 520', 'facebook' => 'metonkft'),
	//'milesi'          => array('name' => 'Milesi',               'parent' => 'mls')
	'mls' => array('name' => 'MLS Magyarország', 'web' => 'https://www.mls.hu/', 'tel' => '+36 24 525 400'),
	'mofem' => array('name' => 'MOFÉM','web' => 'https://www.mofem.hu/',),
	'murexin' => array('name' => 'Murexin', 'web' => 'https://www.murexin.hu/', 'email' => 'murexin@murexin.hu', 'tel' => '+36 1 262 6000', 'facebook' => 'murexinhu', 'instagram' => 'murexinhu', 'linkedin' => 'in/murexin-hu-159124224/', 'tiktok' => '@murexinhungary', 'youtube' => '@murexinhungary105'),
	'norton' => array('name' => 'Norton Saint-Gobain', 'hidden' => TRUE, 'stand' => ['no' => '12A', 'size' => '8x65']),
	'painttech' => array('name' => 'Paint-Tech', 'web' => 'https://www.paint-tech.hu/', 'email' => 'ugyfelszolgalat@paint-tech.hu', 'tel' => '+36 20/350-1545'),
	'pajarito' => array('name' => 'Pajarito', 'parent' => 'uzin'),
	'pallmann' => array('name' => 'Pallmann', 'parent' => 'uzin'),
	'pava' => array('name' => 'Pava', 'parent' => 'anda'),
	'pentacolor' => array('name' => 'Pentacolor', 'web' => 'https://pentart.eu/hu', 'email' => 'info@pentacolor.hu', 'tel' => '+36 (1) 260 7477', 'facebook' => 'pentartofficial', 'instagram' => 'pentartofficial', 'pinterest' => 'pentartofficial', 'tiktok' => '@pentartofficial', 'youtube' => '@pentartvideo'),
	'piktorfestek' => array('name' => 'Piktorfesték', 'web' => 'https://piktorfestek.hu/', 'email' => 'piktorfestek@piktorfestek.hu', 'tel' => '+36 (1) 315 0100', 'facebook' => 'piktorfestekhalozat', 'instagram' => 'piktorfestek_kft', 'tiktok' => '@piktorfestek', 'youtube' => '@piktorfestekkft.9231'),
	//'polymatrix'      => array('name' => 'Poly-Matrix',          'web' => 'https://poly-matrix.hu/webshop/', 'email' => 'info@poly-matrix.hu', 'tel' => '+36 70 886 0672'),
//'prefa'           => array('name' => 'Prefa',                'web' => 'https://www.prefa.hu/', 'email' => 'office.hu@prefa.com', 'tel' => '+36 23 511 670', 'facebook' => 'PREFAMagyarorszag', 'instagram' => 'prefaeurope', 'pinterest' => 'prefadach', 'youtube' => '@PrefaDach'),
//'pvsun'         => array('name' => 'PV-SUN',  'parent' => 'wattbolt'),
//'ravak'           => array('name' => 'RAVAK',                'web' => 'https://www.ravak.hu/', 'email' => 'info@ravak.hu', 'tel' => '+36 1 223 1315', 'facebook' => 'ravakhu', 'instagram' => 'ravakfurdoszoba', 'youtube' => '@RAVAKFurdoszoba'),
//'recycolor'       => array('name' => 'Recycolor',            'web' => 'https://www.recycolor.hu/', 'email' => 'recycolor@recycolor.hu', 'tel' => '+36 1 361 0734', 'facebook' => 'recycolorkft', 'instagram' => 'recycolor_kft', 'youtube' => '@recycolorkft', 'brands' => ['turbosol']),
//'recycolor-graco' => array('name' => 'Graco',    'parent' => 'recycolor'),
//'remmers'         => array('name' => 'Remmers',              'web' => 'https://www.remmers.hu/hu', 'email' => 'info.hu@remmers.com', 'tel' => '+36 23 530 133', 'facebook' => 'Remmersmagyarorszag', 'instagram' => 'remmersmagyarorszag', 'youtube' => 'channel/UCuLt_RXnyoCHrHKQIS4uX6A'),
	'rigips' => array('name' => 'Rigips Saint-Gobain', 'web' => 'https://www.rigips.hu/', 'email' => 'rigips@saint-gobain.com', 'facebook' => 'Rigips.Hungary', 'instagram' => 'saintgobainhungary', 'pinterest' => 'saintgobainnews', 'youtube' => '@RigipsHungary'),
	'rockwool' => array('name' => 'ROCKWOOL', 'web' => 'https://www.rockwool.hu/', 'tel' => '+36 1 225 2400', 'email' => 'info@rockwool.hu', 'facebook' => 'ROCKWOOL.hu', 'youtube' => 'user/RockwoolHungary'),
	//'schuller'        => array('name' => 'Schuller Eh\'klar Kft.', 'web' => 'https://www.schuller.eu/hu/', 'email' => 'hungary@schuller.eu', 'tel' => '+36 72 / 539 100', 'facebook' => 'schullermagyarorszag',  'instagram' => 'schullerehklar', 'tiktok' => '@schullermagyarorszag', 'youtube' => 'channel/UCNs-enji_VC9Py0cbfrlIYA'),
//'selemix'         => array('name' => 'Selemix', 'parent' => 'recycolor'),
	'selena' => array('name' => 'Selena', 'web' => 'https://tytan.com/hu/', 'tel' => '+36 70 3 190 203', 'email' => 'selena.hungaria@selena.com', 'facebook' => 'tytanprofessionalHU', 'youtube' => 'user/TytanHungary'),
	'sigma' => array('name' => 'Sigma &amp; BIHUI-Gate Burkoló szakbolt', 'web' => 'https://bihui.hu/', 'tel' => '+36 20 489 4915', 'facebook' => 'SigmaCsempevago', 'instagram' => 'kalmarteca', 'image' => 1),
	'sika' => array('name' => 'Sika Hungária Kft.', 'web' => 'https://hun.sika.com/', 'email' => 'marketing@hu.sika.com', 'tel' => '+36 1 371 2020', 'facebook' => 'SikaHungaria', 'instagram' => 'sika_hungary', 'youtube' => '@SikaHungary'),
	//'sortimo'         => array('name' => 'Sortimo Járműberendezés', 'web' => 'https://sortimo-jarmuberendezes.hu/', 'email' => 'info@sortimo-jarmuberendezes.hu', 'tel' => '+36 70 578 0591', 'facebook' => 'sortimojarmuberendezes', 'instagram' => 'sortimo_jarmuberendezes', 'youtube' => 'channel/UCGAflKvqC1om7cLKDJ9NIsA', 'tiktok' => '@sortimojarmuberendezes', 'linkedin' => 'company/sortimo-hungary'),
	'soudal' => array('name' => 'Soudal', 'web' => 'https://www.soudal.hu/', 'email' => 'belfold@soudal.hu', 'tel' => '', 'facebook' => 'Soudal.Magyarorszag', 'instagram' => 'soudal.magyarorszag', 'youtube' => '@Soudal-Magyarorszag', 'linkedin' => 'company/soudal-magyarorsz%C3%A1g-kft'),
	'stalco' => array('name' => 'Stalco', 'web' => 'http://eth.hu/', 'email' => 'info@eth.hu', 'tel' => '+36 30 301 33 30', 'facebook' => 'stalcohungary'),
	'stanley' => array('name' => 'Stanley Black & Decker', 'stand' => ['no' => '19', 'size' => '6x7'], 'web' => ['https://www.dewalt.hu/', 'https://www.stanleyworks.hu/'], 'email' => 'info.budapest@sbdinc.com', 'tel' => '+36 1 234 4965', 'facebook' => 'DEWALTHU', 'youtube' => '@dewalttv', 'linkedin' => 'company/stanley-black-decker-inc'),
	'steinel' => array('name' => 'Steinel', 'parent' => 'dinocoop'),
	//'szerelvenybolt'  => array('name' => 'Szerelvenybolt.hu', 'web' => 'https://szerelvenybolt.hu/', 'email' => 'webaruhaz@szerelvenybolt.hu',  'tel' => [' +36 30 265 8491', '+36 30 222 5036'], 'facebook' => 'szerelvenybolt.hu', 'instagram' => 'szerelvenybolt.hu', 'linkedin' => 'company/szerelvenybolt-kft', 'tiktok' => '@szerelvenybolt.hu', 'youtube' => '@szerelvenybolt-hu'),
//'antiqua'         => array('name' => 'Taylor Design - Antiqua', 'web' => 'https://www.antiqua.hu/', 'email' => 'info@antiqua.hu',  'tel' => ['+36 1 262-4365', '+36 1 262-4366']),
	'tboss' => array('name' => 'Tboss', 'web' => 'https://tboss.hu/konyhabutorok/', 'email' => 'konyha@tboss.hu', 'tel' => '+36 30 176 0000'),
	'terran' => array('name' => 'Terrán Tetőcserép Gyártó Kft.', 'web' => ['https://terranteto.hu/', 'https://terran-generon.hu', 'https://tetotepitek.hu/blog/', 'https://terranteto.hu/keszteto'], 'email' => 'vevoszolg@terranteto.hu', 'tel' => '+36 69 569 950', 'facebook' => 'terrantetocserep', 'instagram' => 'terranteto', 'linkedin' => 'company/terr%C3%A1n-tet%C5%91cser%C3%A9p-gy%C3%A1rt%C3%B3-ltd-', 'youtube' => '@TerrantetoHu'),
	'tesa' => array('name' => 'Tesa', 'web' => 'https://www.tesa.com/hu-hu/mesteremberek', 'linkedin' => 'company/tesa', 'youtube' => '@tesamagyarorszag8507'),
	//'thermofloc'      => array('name' => 'Thermofloc - Felföldi Kft.',          'web' => 'https://www.thermoflocinfo.hu/', 'email' => 'info@thermoflocinfo.hu', 'tel' => '+36 20 943 3893'),
	'burkolatszintezo' => array('name' => 'TLS Burkolatszintező Rendszerek  - Felföldi Kft.', 'web' => 'https://burkolatszintezo.hu/', 'email' => 'info@burkolatszintezo.hu', 'facebook' => 'TLSPROFESSIONAL'),
	'trilak' => array('name' => 'PPG Trilak Kft.', 'web' => 'https://trilakfestekstudio.hu/', 'email' => 'vevoszolgalat@ppg.com', 'tel' => '+36/1-421-6100', 'facebook' => 'ppgtrilak', 'instagram' => 'ppgtrilak', 'tiktok' => '@ppgtrilak', 'youtube' => '@ppgtrilak'),
	//'turbosol'        => array('name' => 'Turbosol Kft',          'web' => 'https://turbosol.hu/', 'email' => 'info@turbosol.hu', 'facebook' => 'people/Turbosol-Kft/100057055856751/',  'youtube' => '@turbosolkft6225'),
	'tytan' => array('name' => 'Tytan', 'parent' => 'selena'),
	'uzin' => array('name' => 'Uzin Utz Magyarország Kft', 'web' => ['https://hu.uzin.com/', 'https://int.uzin.com/'], 'email' => 'iroda.hu@uzin-utz.com', 'tel' => ['+36 30 701 1502', '+36 1 431 9422'],'brands' => ['uzin','wolff','pallmann','pajarito','arturo','codex']),
	//'vipvita'         => array('name' => 'Vip Vitaportál',       'web' => 'https://www.vipvitaportal.hu/', 'email' => 'graco@vipvitaportal.hu', 'tel' => ['+36 70 616 36 03', '+36 70 634 36 03'], 'facebook' => 'vipvitaportal', 'instagram' => '', 'youtube' => ''),
	'wagner' => array('name' => 'Wagner', 'parent' => 'dinocoop'),
	//'wattbolt'        => array('name' => 'WattBolt',   'web' => ['https://www.wattbolt.com/', 'https://pv-sun.hu/', 'https://greewer.hu/'], 'email' => 'info@pv-sun.hu', 'phone' => '+36 70 930 2978', 'facebook' => 'profile.php?id=100094126823305', 'linkedin' => 'company/pv-sun-kft/'),
	'weber' => array('name' => 'Weber Saint-Gobain', 'web' => 'https://www.hu.weber/', 'email' => 'info@hu.weber', 'facebook' => 'weberhungary', 'instagram' => 'saintgobainhungary', 'pinterest' => 'saintgobainnews', 'youtube' => '@weberhungary'),
	//'wendy'      	  => array('name' => 'Wendy',	'parent' => 'chromos'),
	'wolfcraft' => array('name' => 'Wolfcraft', 'parent' => 'dinocoop'),
	'wolff' => array('name' => 'Wolff', 'parent' => 'uzin'),
	'xella' => array('name' => 'Xella Magyarország Kft', 'web' => ['https://www.xella.hu/', 'https://epiteniakarok.blog.hu/'], 'email' => 'zoldszam@xella.com', 'tel' => '+36 80 69 69 00', 'facebook' => 'Ytong.hivatalos', 'youtube' => '@Xellamagyar', /*'brands' => ['ytong','silka','multipor']*/),
	'paliszander' => array( 'name' => 'Paliszander Kft','web' => 'https://paliszander.hu/','email' => 'webshop@paliszander.hu','tel' => '+361-770-7017','facebook' => 'paliszanderkft','instagram' => 'paliszander.kft','youtube' => '@paliszander01','tiktok' => '@paliszander33','linkedin' => 'company/paliszander-kft/?viewAsMember=true'),
	'milesi' => array('name' => 'Milesi'), //, 'web' => 'https://webshop.mls.hu/', 'email' => 'info@milesi.hu', 'tel' => '+36 1 234 5678', 'facebook' => 'milesihungary', 'instagram' => 'milesihungary', 'youtube' => '@milesihungary'),
	'hafele' => array('name' => 'Häfele','web' => 'https://www.hafele.com/', 'email' => 'info@hafele.hu', 'tel' => '+36 1  950 4437', 'facebook' => 'gyenes.robert.9', 'instagram' => 'hafelehungary', 'youtube' => '@HaefeleDE'),
	'gtv' => array('name' => 'GTV', 'web' => 'https://triomaxhungary.hu/', 'email' => 'info@gtv.hu', 'tel' => '+36 1 234 5678', 'facebook' => 'gtvhungary', 'instagram' => 'gtvhungary', 'youtube' => '@gtvhungary'),
	'triomax' => array('name' => 'Triomax'), //'web' => 'https://www.triomax.hu/', 'email' => 'info@triomax.hu', 'tel' => '+36 1 234 5678', 'facebook' => 'triomaxhungary', 'instagram' => 'triomaxhungary', 'youtube' => '@triomaxhungary'),
	'cvnfront' => array('name' => 'CVN Front','web' => 'https://www.cvnfront.hu/', 'email' => ' info@cvnfront.com', 'tel' => '36203187779', 'facebook' => 'CVNfront', 'instagram' => 'cvn_front'),
	'hettich' => array('name' => 'Hettich', 'web' => 'https://shop.hettich.com/hu_HU', 'email' => 'info@hettich.hu', 'tel' => '+36 1 234 5678', 'facebook' => 'hettichhungary', 'instagram' => 'hettichhungary', 'youtube' => '@hettichhungary','parent' => 'butorvonal'),
	'kessebohmer' => array('name' => 'Kesseböhmer', 'web' => 'https://www.kesseboehmer.com/en', 'email' => 'info@kessebohmer.hu', 'tel' => '+36 1 234 5678', 'facebook' => 'kessebohmerhungary', 'instagram' => 'kessebohmerhungary', 'youtube' => '@kessebohmerhungary', 'parent' => 'butorvonal'),
	'solaflex' => array('name' => 'Solaflex',"web" => 'https://www.solaflex.com/','parent' => 'butorvonal' ),
	'tulip' => array('name' => 'Tulip','parent' => 'demos'),
	'demos' => array('name' => 'Démos', "web" => 'https://demos-trade.com','email' => 'megrendelesek@demos-trade.com','tel' => '+36 1 445 3730','facebook' => 'demostrade','linkedin' => '/company/démos-trade-a-s-/','youtube' => 'demostrade','brands' => ['demos','strong','tulip']),
	'strong' => array('name' => 'Strong', "web" => 'https://www.strong.com/', 'parent' => 'demos'),
	'zakanyszerszam' => array('name' => 'Zákány Szerszámház', "web" => 'https://zakanyszerszamhaz.hu/', 'tel'=>'+36 1 808 9567','facebook' => 'zakanyszerszamhazkft'),
	'hailo' => array('name' => 'Hailo', 'parent' => 'butorvonal'),
	'spatrends' => array('name' => 'Spatrends'),
	'parador' => array('name' => 'Parador'),
	'geberit' => array('name' => 'Geberit'),
	'ganteline' => array('name' => 'Ganteline','web' => 'https://www.ganteline.hu/','email' => 'info.hu@coverguard-safety.com','tel' => '+36-23/364-144','facebook' => 'ganteline.coverguard'),

);
ksort($cegek);

// Kategoriák feltöltése a szűréshez
$csv = array_map('str_getcsv', file('../emw/cats.csv'));
array_walk($csv, function (&$a) use ($csv) {
	$a = array_combine($csv[0], $a);
});
$categories = array_shift($csv);
$categories = array_slice($categories, 2); // name, slug
foreach ($csv as $row)
	foreach ($row as $cat => $van)
		if (trim($van) === 'x' and isset($cegek[$row['slug']]))
			$cegek[$row['slug']]['cats'][] = $cat;

// Főkategóriák és alkategóriák definiálása
$main_categories = array(
  'Szerkezetek és építőanyagok' => array(
    'Építőanyagok',
    'Tetőfedés',
	'Burkolás',
    'Hő- és hangszigetelés',
    'Vízszigetelés',
    'Gépészet'
  ),
 
  'Szerszámok és gépek' => array(
    'Szerszámok és gépek',
    'Haszongépjármű és berendezés',
    'Létrák, állványok'
  ),
  
  'Asztalosipar' => array(
    'Asztalosipar',
    'Faipari alapanyag',
    'Asztalos szerszámok',
    'Vasalatok, szerelvények',
    'Fafelületkezelés, vegyi anyagok'
  ),
  
  'Felületkezelés és segédanyagok' => array(
    'Festés, mázolás',
    'Segédanyagok'
  ),
  
  'Munkavédelem és oktatás' => array(
    'Munkaruházat',
    'Biztonságtechnika',
    'Oktatás'
  )
);

// Kategória CSV beolvasás és átalakítás fő kategóriák szerint
$csv = array_map('str_getcsv', file('../emw/cats.csv'));
array_walk($csv, function (&$a) use ($csv) {
	$a = array_combine($csv[0], $a);
});
array_shift($csv); // Remove header
$sub_to_main = [];
foreach ($main_categories as $main => $subs) {
    foreach ($subs as $sub) {
        $sub_to_main[$sub] = $main;
    }
}

// Új kategória lista: csak főkategóriák
$categories = array_keys($main_categories);

// Cégek kategóriáinak feltöltése fő kategória alapján
foreach ($csv as $row) {
	$slug = $row['slug'];
	if (!isset($cegek[$slug])) continue;

	foreach ($row as $cat => $has) {
		if (trim($has) === 'x' && isset($sub_to_main[$cat])) {
			$main_cat = $sub_to_main[$cat];
			// Csak egyszer adjuk hozzá
			if (!isset($cegek[$slug]['cats']) || !in_array($main_cat, $cegek[$slug]['cats'])) {
				$cegek[$slug]['cats'][] = $main_cat;
			}
		}
	}
}






// Standokat most utolag tesszuk ra. Osszevonasra kerult a ket tomb, de igy gyorsabb mint kezzel atvinni
$standok = array();
$standok[] = ['standNo' => '1', 'slug' => 'tesa', 'size' => '4x4'];
$standok[] = ['standNo' => '2', 'slug' => 'schuller', 'size' => '8x7'];
$standok[] = ['standNo' => '3', 'slug' => 'kallofem', 'size' => '4x1'];
$standok[] = ['standNo' => '4', 'slug' => 'krause', 'size' => '5x3'];
$standok[] = ['standNo' => '5', 'slug' => 'mls', 'size' => '7x7'];
$standok[] = ['standNo' => '6A', 'slug' => 'metalsheet', 'size' => '6x7'];
$standok[] = ['standNo' => '6B', 'slug' => 'bauhaus', 'size' => '6x7'];
$standok[] = ['standNo' => '8', 'slug' => 'domotors', 'size' => '5x5'];
$standok[] = ['standNo' => '10', 'slug' => 'polymatrix', 'size' => '4x6'];
$standok[] = ['standNo' => '11A', 'slug' => 'kvarc', 'size' => '5x5'];
$standok[] = ['standNo' => '11B', 'slug' => 'selena', 'size' => '5x8'];
$standok[] = ['standNo' => '12A', 'slug' => 'isover', 'size' => '8x65'];
$standok[] = ['standNo' => '12A', 'slug' => 'rigips', 'size' => '8x65'];
$standok[] = ['standNo' => '12A', 'slug' => 'weber', 'size' => '8x65'];
$standok[] = ['standNo' => '12B', 'slug' => 'terran', 'size' => '8x65'];
$standok[] = ['standNo' => '13', 'slug' => 'atlas', 'size' => '8x7'];
$standok[] = ['standNo' => '14', 'slug' => 'trilak', 'size' => '8x7'];
$standok[] = ['standNo' => '14', 'slug' => 'kohazy', 'size' => '8x7'];
$standok[] = ['standNo' => '15', 'slug' => 'hikoki', 'size' => '8x7'];
$standok[] = ['standNo' => '16', 'slug' => 'sigma', 'size' => '8x7'];
$standok[] = ['standNo' => '17', 'slug' => 'bosch', 'size' => '6x7'];
$standok[] = ['standNo' => '17', 'slug' => 'zakanyszerszam', 'size' => '6x7'];
$standok[] = ['standNo' => '18', 'slug' => 'botament', 'size' => '6x7'];
$standok[] = ['standNo' => '20', 'slug' => 'dinocoop', 'size' => '6x7'];
$standok[] = ['standNo' => '21', 'slug' => 'knauf', 'size' => '10x14'];
$standok[] = ['standNo' => '21', 'slug' => 'knaufinsulation', 'size' => '10x14'];
$standok[] = ['standNo' => '21', 'slug' => 'cemix', 'size' => '10x14'];
$standok[] = ['standNo' => '23', 'slug' => 'husqvarna', 'size' => '5x9'];
$standok[] = ['standNo' => '24', 'slug' => 'chromos', 'size' => '4x9'];
$standok[] = ['standNo' => '25A', 'slug' => 'aco', 'size' => '4x5'];
$standok[] = ['standNo' => '25B', 'slug' => 'knaufceiling', 'size' => '5x5'];
$standok[] = ['standNo' => '26', 'slug' => 'egrokorr', 'size' => '4x7'];
$standok[] = ['standNo' => '27', 'slug' => 'diatech', 'size' => '4x7'];
$standok[] = ['standNo' => '28A', 'slug' => 'thermofloc', 'size' => '4x5'];
$standok[] = ['standNo' => '28B', 'slug' => 'leicon', 'size' => '4x5'];
$standok[] = ['standNo' => '29', 'slug' => 'merkbau', 'size' => '5x10'];
$standok[] = ['standNo' => '30', 'slug' => 'meton', 'size' => '10x10'];
$standok[] = ['standNo' => '31', 'slug' => 'mapei', 'size' => '12x10'];
$standok[] = ['standNo' => '32', 'slug' => 'rockwool', 'size' => '8x10'];
$standok[] = ['standNo' => '33', 'slug' => 'baumit', 'size' => '8x10'];
$standok[] = ['standNo' => '34', 'slug' => 'remmers', 'size' => '8x5'];
$standok[] = ['standNo' => '35', 'slug' => 'vipvita', 'size' => '8x5'];
$standok[] = ['standNo' => '37', 'slug' => 'laufen', 'size' => '5x10'];
$standok[] = ['standNo' => '37', 'slug' => 'jika', 'size' => '5x10'];
$standok[] = ['standNo' => '38', 'slug' => 'innopan', 'size' => '4x6'];
$standok[] = ['standNo' => '39', 'slug' => 'braunbau', 'size' => '4x6'];
$standok[] = ['standNo' => '40', 'slug' => 'henkel', 'size' => '5x10'];
$standok[] = ['standNo' => '40', 'slug' => 'ceresit', 'size' => '5x10'];
$standok[] = ['standNo' => '41', 'slug' => 'dufa', 'size' => '8x5'];
$standok[] = ['standNo' => '42', 'slug' => 'prefa', 'size' => '8x5'];
$standok[] = ['standNo' => '43', 'slug' => 'recycolor', 'size' => '8x10'];
$standok[] = ['standNo' => '45', 'slug' => 'anda', 'size' => '8x10'];
$standok[] = ['standNo' => '45', 'slug' => 'helios', 'size' => '8x10'];
$standok[] = ['standNo' => '45', 'slug' => 'turbosol', 'size' => '8x10'];
$standok[] = ['standNo' => '46A', 'slug' => 'leier', 'size' => '6x10'];
$standok[] = ['standNo' => '46B', 'slug' => 'sika', 'size' => '6x10'];
$standok[] = ['standNo' => '47', 'slug' => 'bramac', 'size' => '10x10'];
$standok[] = ['standNo' => '48', 'slug' => 'antiqua', 'size' => '4x10'];
$standok[] = ['standNo' => '49A', 'slug' => 'wattbolt', 'size' => '5x5'];
$standok[] = ['standNo' => '49B', 'slug' => 'kiralyhazak', 'size' => '5x5'];
$standok[] = ['standNo' => '50', 'slug' => 'painttech', 'size' => '4x5'];
$standok[] = ['standNo' => '51', 'slug' => 'buzon', 'size' => '4x5'];
$standok[] = ['standNo' => '52', 'slug' => 'mester', 'size' => '4x5'];
$standok[] = ['standNo' => '53', 'slug' => 'fatraizolfa', 'size' => '5x5'];
$standok[] = ['standNo' => '55', 'slug' => 'ravak', 'size' => '10x4'];
$standok[] = ['standNo' => '56', 'slug' => 'matrixoktatas', 'size' => '5x4'];
$standok[] = ['standNo' => '57', 'slug' => 'soudal', 'size' => '5x5'];
$standok[] = ['standNo' => '58', 'slug' => 'metabo', 'size' => '5x4'];
$standok[] = ['standNo' => '59', 'slug' => 'exctools', 'size' => '6x4'];
$standok[] = ['standNo' => '60', 'slug' => 'szerelvenybolt', 'size' => '5x4'];
$standok[] = ['standNo' => '61', 'slug' => 'collomix', 'size' => '4x5'];
$standok[] = ['standNo' => '63', 'slug' => 'sortimo', 'size' => '3x6'];
$standok[] = ['standNo' => '64', 'slug' => 'uzin', 'size' => '6x6'];
$standok[] = ['standNo' => '9', 'slug' => 'klimaexpress', 'size' => '4x11'];

foreach ($standok as $row) {
	if (empty($cegek[$row['slug']]))
		continue;
	$cegek[$row['slug']]['stand'] = ['no' => $row['standNo'], 'size' => $row['size']];
}
// Standok 
$standok = array();
foreach ($cegek as $slug => $row) {
	if (empty($row['stand']))
		continue;
	if (empty($row['cats']))
		$row['cats'] = array();

	$stands = $row['stand'];
	if (isset($row['stand']['no'])) // vagyis csak egy standon van a ceg, nem tomb
		$stands = [$row['stand']]; // tombbe alakitjuk
	foreach ($stands as $stand)
		$standok[] = ['standNo' => $stand['no'], 'size' => $stand['size'], 'slug' => $slug, 'name' => $row['name'], 'cats' => implode(' ', $row['cats'])];
}
// Nev szerinti sorrend
uasort($standok, function ($a, $b) {
	$nev1 = $a['name'] ?? strtolower($a['slug']);
	$nev2 = $b['name'] ?? strtolower($b['slug']);
	return $nev1 <=> $nev2;
});
// Egyelore ures standok
//$standok[] = ['standNo' => '60', 'slug'=>'','size'=>'5x4'];


/*
$programok = array(
	array('idopont' => 'péntek 09:30', 'slug' => 'mapei', 'title' => 'Pavelka Orsolya és Dorvos Máriusz –	Óriáslapok, ragasztás és  expoxy fugázás a gyakorlatban.'),
	array('idopont' => 'péntek 10:00', 'slug' => 'remmers', 'title' => 'Ladányi Kristóf	– Újgenereciós vízszigetelési megoldások minden helyzetre'),
	array('idopont' => 'péntek 10:30', 'slug' => 'mapei', 'title' => 'Gulyás Gergely – Mapei hőszigetelő rendszerek  avagy részletekből áll össze az egész! A Mapei figyel a legkisebb kiegészítőkre is!'),
	array('idopont' => 'péntek 11:00', 'slug' => 'bramac', 'title' => 'Viniczai Róbert és Gebhardt Roland – Spórolj időt a BMI időtakarékos megoldásaival! Legyen az magas-, lapos tető vagy alépítményi vízszigetelés!'),
	array('idopont' => 'péntek 11:30', 'slug' => 'sika', 'title' => 'Halmai Zsolt: Varázslat a falon<br>Dekoratív felület képzés beltérben - SikaWall®-550 Magic'),
	array('idopont' => 'péntek 12:30', 'slug' => 'prefa', 'title' => 'Forró Sándor - PREFA a modern világban'),
	array('idopont' => 'péntek 13:30', 'slug' => 'weber', 'title' => 'Vízszigetelés és hidegburkolás egyben: weberxerm 844'),
	array('idopont' => 'péntek 14:00', 'slug' => 'terran', 'title' => 'Filus Róbert – Ha kérdés a tető válasz a Terrán'),
	array('idopont' => 'péntek 14:30', 'slug' => 'meton', 'title' => 'Meton + EJOT közös előadása – Hőszigetelő rendszer'),
	array('idopont' => 'péntek 15:00', 'slug' => 'bramac', 'title' => 'Viniczai Róbert és Gebhardt Roland – Spórolj időt a BMI időtakarékos megoldásaival! Legyen az magas-, lapos tető vagy alépítményi vízszigetelés!'),
	array('idopont' => 'péntek 15:30', 'slug' => 'norton', 'title' => 'Norton: Nagyméretű  burkolólapok méretpontos vágása'),

	array('idopont' => 'szombat 09:30', 'slug' => 'mapei', 'title' => 'Pavelka Orsolya és Dorvos Máriusz –	Óriáslapok, ragasztás és  expoxy fugázás a gyakorlatban.'),
	array('idopont' => 'szombat 10:00', 'slug' => 'remmers', 'title' => 'Ladányi Kristóf	– Újgenereciós vízszigetelési megoldások minden helyzetre'),
	array('idopont' => 'szombat 10:30', 'slug' => 'mapei', 'title' => 'Gulyás Gergely – Mapei hőszigetelő rendszerek  avagy részletekből áll össze az egész! A Mapei figyel a legkisebb kiegészítőkre is!'),
	array('idopont' => 'szombat 11:00', 'slug' => 'bramac', 'title' => 'Viniczai Róbert és Gebhardt Roland – Spórolj időt a BMI időtakarékos megoldásaival! Legyen az magas-, lapos tető vagy alépítményi vízszigetelés!'),
	array('idopont' => 'szombat 11:30', 'slug' => 'terran', 'title' => 'Filus Róbert – Ha kérdés a tető válasz a Terrán'),
	array('idopont' => 'szombat 12:00', 'slug' => 'sika', 'title' => 'Halmai Zsolt: Varázslat a falon<br>Dekoratív felület képzés beltérben - SikaWall®-550 Magic'),
	array('idopont' => 'szombat 12:30', 'slug' => 'prefa', 'title' => 'Forró Sándor - PREFA a modern világban'),
	array('idopont' => 'szombat 14:00', 'slug' => 'meton', 'title' => 'Kostoláni Roman	– Lapostető hőszigetelés, lejtésképzés'),
	array('idopont' => 'szombat 14:30', 'slug' => 'norton', 'title' => 'Norton: Nagyméretű  burkolólapok méretpontos vágása'),
	array('idopont' => 'szombat 15:00', 'slug' => 'bramac', 'title' => 'Viniczai Róbert és Gebhardt Roland – Spórolj időt a BMI időtakarékos megoldásaival! Legyen az magas-, lapos tető vagy alépítményi vízszigetelés!'),
);



$programokCegek = array();
foreach ($programok as $index => $row) {
	$programok[$index]['ceg'] = $cegek[$row['slug']]['name'];
	$programok[$index]['stand'] = $cegek[$row['slug']]['stand']['no'];
	$programokCegek[$row['slug']] = 1;
}
$programokCegek = array_keys($programokCegek);
*/

// https://www.homeinfo.hu/jegyvasarlas/__nyeremenyek.php
$nyeremenyek = array(

	/*'anda' => array(
		array(
			'title' => 'Graphite falcsiszoló gép',
			'price' => '84 190 Ft',
			'desc' => ['1 db Graphite 59G261 falcsiszoló gép', '600W', '225mm', 'hordtáskával'],
		),
	),*/
	'ceresit' => array(
		array(
			'title' => '5 db Ceresit ajándékcsomag:',
			'price' => '',
			'desc' => ['1 db Ceresit széldzseki', '1 db Ceresit póló', '1 db Ceresit fejlámpa', '1-1 db Ceresit autóillatosító, ácsceruza, sniccer'],
			'amount' => '5',
		),
	),/*
'dinocoop' => array(
  array(
	  'filename' => '1',
	  'title' => '1 db W100 festékszóró',
	  'price' => '',
	  'desc' => 'Más Click&Paint lakk és lazúr szórófejekkel is használható. Elektromos teljesítmény 280 W, porlasztási teljesítmény 65 W. Tartály űrtartalma 800 ml. Festékmennyiség fokozatmentesen szabályozható, 0-110 ml / min. Max. viszkozitás 90 DIN-sec.',
	  'amount' => '1',
  ),
  array(
	  'filename' => '2',
	  'title' => '1 db W590 Flexio univerzális festékszóró',
	  'price' => '',
	  'desc' => 'A készülék a többi Click&Paint szórófejjel is használható. Az új X-Boost turbina erősebb és csendesebb az eddigi megoldásoknál. A turbina a szórt anyag sűrűségéhez igazodva több fokozatba állítható. Elektromos teljesítmény 630 W. A porlasztási teljesítmény 25 W - 200 W között, a szállított festékmennyiség fokozatmentesen 0 - 500 ml / min között állítható. A legtöbb beltéri falfestékkel hígítás nélkül használható. Praktikus műanyag kofferben szállítjuk.',
	  'amount' => '1',
  ),
  array(
	  'filename' => '3',
	  'title' => '4 db 20.000 Ft értékű utalvány',
	  'price' => '20 000 Ft',
	  'desc' => '',
	  'amount' => '4',
  ),
),
'sigma' => array(
  array(
	  'title' => 'BIHUI lapemelő és lapösszehúzó egyben',
	  'price' => '',
	  'desc' => '',
  ),
  array(
	  'title' => 'Sigma csempevágó 37 cm',
	  'price' => '',
	  'desc' => '',
  ),
),
'klimaexpress' => array(
  array(
	  'filename' => '1',
	  'title' => 'Karmos kalapács',
	  'price' => '9 144 Ft',
	  'desc' => 'Kombinált eszköz, ahogy azt a profik kitalálták az iparosok számára.  650 grammos kalapács,  azonos kialakítású karmokkal. Acélötvözet nyele puha bevonattal a kényelmes de biztos markolathoz.',
	  'amount' => '2',
  ),
  array(
	  'filename' => '2',
	  'title' => 'Vékony, mintás sapka',
	  'price' => '6 942 Ft',
	  'desc' => 'Rugalmas, 100%-ban pamut alapanyagból. Tökéletes illeszkedés, dinamikus megjelenés és maximális kényelem egyszerre.',
	  'amount' => '3',
  ),
  array(
	  'filename' => '3',
	  'title' => 'FlexiWork polár sapka',
	  'price' => '7 865 Ft',
	  'desc' => 'Rugalmas, meleg, kívül sima, belül bolyhos alapanyagból készül a hideg elleni védelemre.   Nagyon kényelmes és igazán melengető érzés a viselése. Nagy mintája vagánnyá teszi. ',
	  'amount' => '2',
  ),
  array(
	  'filename' => '4',
	  'title' => 'Snickers Precision Flex Kesztyű',
	  'price' => '2 142 Ft',
	  'desc' => 'Praktikus, számos területen kiválóan alkalmazható mártott kesztyű Svédországból.  Vékony, jól szellőzik és könnyen rásimul a kézre. Mártott területe enyhén szemcsés a fogásbiztonság érdekében. Széles körben felhasználható, roppant tartós és kényelmes védőkesztyű.',
	  'amount' => '4',
  ),
  array(
	  'filename' => '5',
	  'title' => 'Xenon áttetsző Hellberg szemüveg',
	  'price' => '5 969 Ft',
	  'desc' => 'Praktikus, számos területen kiválóan alkalmazható mártott kesztyű Svédországból.  Vékony, jól szellőzik és könnyen rásimul a kézre. Mártott területe enyhén szemcsés a fogásbiztonság érdekében. Széles körben felhasználható, roppant tartós és kényelmes védőkesztyű.',
	  'amount' => '2',
  ),
  array(
	  'filename' => '6',
	  'title' => 'Craftman kés  Svédországból',
	  'price' => '2 540 Ft',
	  'desc' => ['Speciálisan kialakított Hultafors kés általános célokra.', '93 mm hosszú és 2,5 mm széles japán szénacél pengével.', 'Tömör, mégis könnyű műanyag nyéllel, stabil markolattal.', 'Hosszú idő óta tartósan népszerű termék.'],
	  'amount' => '5',
  ),
  array(
	  'filename' => '8',
	  'title' => 'CLC szerszámos kistáska Amerikából',
	  'price' => '7 773 Ft',
	  'desc' => 'Kisméretű szerszámostáska strapabíró alapanyagból, számos praktikus rekesszel kívül- belül egyaránt. Tágas rakodótérrel, erős fülekkel és pánttal. Széles, fém merevítővel ellátott cipzáras szája megkönnyíti a táskában való kotorászást.',
	  'amount' => '2',
  ),
  array(
	  'filename' => '9',
	  'title' => 'Dielekltromos biztonsági szemüveg',
	  'price' => '1 784 Ft',
	  'desc' => 'Teljesen fémmentes. Strapabíró, modern stílusú. Stabil szára kétféle alapanyag kombinációjával készült, aminek lyukacsos kialakítása jó szellőzést nyújt. Megfelel az EN 166 1 FT szabványnak, ezen túl ezen túl víztiszta változata az EN170 2C-1.2, ANSI Z87.1+ míg a sötétített lencséjű modell az EN172 5-3.1 és ANSI Z87.1+ U6 L3 szabványnak is. Elérhető víztiszta és sötétített árnyalatban is.',
	  'amount' => '5',
  ),
  array(
	  'filename' => '10',
	  'title' => 'Mini feszítő acélból',
	  'price' => '3 683 Ft',
	  'desc' => 'A mindössze 19 cm-es eszköz hatalmas segítséget nyújt szűk helyen történő tevékenységekhez. Akár lécek eltávolítása, esetleg dobozok felnyitása a cél. Sőt, szögek eltávolítására egyenesen három különböző módszert is kínál ez a könnyű kis acélrúd. ',
	  'amount' => '5',
  ),
  array(
	  'filename' => '11',
	  'title' => 'Power Core védőkesztyű',
	  'price' => '16 200 Ft',
	  'desc' => 'Mindenféle mechanikai vádelemre. Ergonomikus kialakítás, párnázott tenyér, szellőző kézfej, biztos fogás, rugalmas csukló rész, és az ökölcsontok maximális védelme jellemzi.    Magas kopásállóság mellett szúrással, vágással és szakadással szemben is némi ellenállással bír. Anyaga: Poliamid 50%, poliuretán 40%, poliészter 3%, PVC 5%, szilícium 2%.',
	  'amount' => '3',
  ),
  array(
	  'filename' => '12',
	  'title' => 'Pulóver mellkasmintával',
	  'price' => '10 795 Ft',
	  'desc' => 'Kívül sima, belül finom meleg bolyhos felület munkában is a legotthonosabb érzetért. Nyaknál, az alján és ujjvégein erős rugalmas passzé, így a szél sem fúj alá és a fazonját is sokáig megőrzi.  A klasszikus fazont ellensúlyozza a mellkason megjelenő élénk minta, ami dinamikát csempész a megjelenésbe.',
	  'amount' => '2',
  ),
),
'knaufceiling' => array(
  array(
	  'title' => 'Knauf Ceiling ajándékcsomag',
	  'price' => '',
	  'desc' => ['Álmennyezetszereléshez szükséges textilkesztyű', 'Zollstock', 'Ácsceruza', 'Gravírozott parker toll', 'Knauf Ceiling logóval nyomott határidőnapló'],
  ),
),*/
	'krause' => array(
		array(
			'title' => 'Dopplo lépcsőfokos két oldalon járható létra',
			'price' => '19 180 Ft',
			'desc' => ['Könnyű, mindkét oldalon járható alumínium állólétra 3,30 m-es munkamagasságig (8 fokos változat)', 'Robusztus, ütésálló acél csuklókapcsolatok', '6 helyen szegecselt, robusztus kapcsolat a fokok és a szár között, amely nagyfokú stabilitást kölcsönöz', 'Csúszásmentes, bordázott, padlókímélő lábdugók', 'Szakadásbiztos hevederek', 'A két oldalon járható állólétrákra csak a felülről számított harmadik lépcső-/létrafokig szabad fellépni az EN 131 – 3. szabványnak megfelelően'],
		),
	),/*
'merkbau' => array(
  array(
	  'title' => 'Bautool gyémántfúró készlet',
	  'price' => '44 900 Ft',
	  'desc' => ['Méretek: 20,35,40,51,67 mm', 'Sarokcsiszolóhoz (M14)', 'Kofferben'],
  ),
  array(
	  'title' => 'Bihui keverőgép',
	  'price' => '52 900 Ft',
	  'desc' => ['Teljesítmény: 1200W', 'Befogás: M14'],
  ),
),
'prefa' => array(
  array(
	  'title' => 'Ruhacsomag',
	  'price' => '',
	  'desc' => '',
  ),
),
'ravak' => array(
  array(
	  'title' => 'RAVAK szerszámdoboz',
	  'price' => '',
	  'desc' => ['Fogantyúval és biztonsági csatos zárral', 'Felső osztályzós tálcával', 'Fekete színben'],
  ),
),
'terran' => array(
  array(
	  'filename' => '1',
	  'title' => 'Terrán ajándékcsomag',
	  'price' => '',
	  'desc' => ['Bögre', 'Dzseki'],
	  'amount' => '4',
  ),
),*/
	'tesa' => array(
		array(
			'title' => 'tesa® nyereménycsomag',
			'price' => '17 000 Ft',
			'desc' => ['1db Pevalin kéztisztító kendő', '1db Pevalin kéztisztító krém 500ml', '2 db tesa® 4352 Univerzális maszkolószalag 50m x 30mm'],
		),
	),/*
'trilak' => array(
  array(
	  'filename' => '1',
	  'title' => 'PPG Trilak ajándékcsomag',
	  'price' => '',
	  'desc' => ['Héra póló', 'Héra Festőnadrág', 'Héra baseball sapka', 'Voice of Color színkártya', '2 db új Héra Beltéri Falfesték 15L (budapesti Mintaboltunkban vehető majd át)', '1 db Héra Prémium Latex 3in1 alapozó festék 10L (budapesti Mintaboltunkban vehető majd át)'],
	  'amount' => '2',
  ),
),
'uzin' => array(
  array(
	  'title' => 'UZIN ajándékcsomag 10 db',
	  'price' => '',
	  'desc' => ['1db UZIN póló ', '1db UZIN bögre', 'Irodacsomag (jegyzettömb, toll, post-it, ácsceruza, collstock)'],
	  'amount' => '10',
  ),
),
'zakanyszerszam' => array(
  array(
	  'filename' => '1',
	  'title' => 'Zákány Szerszámház ajándékcsomag',
	  'price' => '',
	  'desc' => ['esernyő', 'kulacs', 'toll', 'szerszámosláda', 'Bosch Pro 35 részes bit és fúrókészlet'],
	  'amount' => '1',
  ),
),*/
);



$nyeremenyek_en = array(

	/*'anda' => array(
		array(
			'title' => 'Graphite wall sander',
			'price' => '84,190 Ft',
			'desc' => ['1 pc Graphite 59G261 wall sander', '600W', '225mm', 'with carrying case'],
		),
	),*/
	'ceresit' => array(
		array(
			'title' => '5 pcs Ceresit gift package:',
			'price' => '',
			'desc' => ['1 pc Ceresit windbreaker', '1 pc Ceresit T-shirt', '1 pc Ceresit headlamp', '1 pc each of: Ceresit car air freshener, carpenter pencil, utility knife'],
			'amount' => '5',
		),
	),/*
'dinocoop' => array(
  array(
	  'filename' => '1',
	  'title' => '1 pc W100 paint sprayer',
	  'price' => '',
	  'desc' => 'Compatible with other Click&Paint lacquer and glaze nozzles. Electrical power: 280 W, atomization power: 65 W. Tank capacity: 800 ml. Paint output adjustable between 0–110 ml/min. Max. viscosity: 90 DIN-sec.',
	  'amount' => '1',
  ),
  array(
	  'filename' => '2',
	  'title' => '1 pc W590 Flexio universal paint sprayer',
	  'price' => '',
	  'desc' => 'Compatible with other Click&Paint nozzles. The new X-Boost turbine is stronger and quieter than previous models. Adjustable power levels based on paint density. Electrical power: 630 W. Atomization power: 25–200 W. Paint flow: 0–500 ml/min, adjustable. Usable without dilution with most interior wall paints. Comes in a practical plastic case.',
	  'amount' => '1',
  ),
  array(
	  'filename' => '3',
	  'title' => '4 pcs vouchers worth 20,000 Ft each',
	  'price' => '20,000 Ft',
	  'desc' => '',
	  'amount' => '4',
  ),
),
'sigma' => array(
  array(
	  'title' => 'BIHUI tile lifter and tile puller combo',
	  'price' => '',
	  'desc' => '',
  ),
  array(
	  'title' => 'Sigma tile cutter 37 cm',
	  'price' => '',
	  'desc' => '',
  ),
),
'klimaexpress' => array(
  array(
	  'filename' => '1',
	  'title' => 'Claw hammer',
	  'price' => '9,144 Ft',
	  'desc' => 'Multipurpose tool designed by professionals for tradespeople. 650g hammer with identical claw shape. Steel alloy handle with soft grip for a secure and comfortable hold.',
	  'amount' => '2',
  ),
  array(
	  'filename' => '2',
	  'title' => 'Thin, patterned beanie',
	  'price' => '6,942 Ft',
	  'desc' => 'Stretchy, made from 100% cotton. Perfect fit, dynamic look, and maximum comfort all in one.',
	  'amount' => '3',
  ),
  array(
	  'filename' => '3',
	  'title' => 'FlexiWork fleece beanie',
	  'price' => '7,865 Ft',
	  'desc' => 'Warm, elastic fabric – smooth outside, brushed inside – for cold weather protection. Very comfortable and cozy to wear. Large graphic makes it look bold.',
	  'amount' => '2',
  ),
  array(
	  'filename' => '4',
	  'title' => 'Snickers Precision Flex Gloves',
	  'price' => '2,142 Ft',
	  'desc' => 'Practical dipped gloves from Sweden, suitable for various tasks. Thin, breathable, fits snugly. The dipped surface is lightly textured for better grip. Extremely durable and comfortable.',
	  'amount' => '4',
  ),
  array(
	  'filename' => '5',
	  'title' => 'Xenon transparent Hellberg safety glasses',
	  'price' => '5,969 Ft',
	  'desc' => 'Practical, highly versatile dipped gloves from Sweden. Thin, breathable, fits snugly. Lightly textured surface ensures grip. Durable and comfortable for multiple applications.',
	  'amount' => '2',
  ),
  array(
	  'filename' => '6',
	  'title' => 'Craftman knife from Sweden',
	  'price' => '2,540 Ft',
	  'desc' => ['Specially designed general-purpose Hultafors knife.', '93 mm long and 2.5 mm wide Japanese carbon steel blade.', 'Solid yet lightweight plastic handle with a stable grip.', 'A consistently popular product over time.'],
	  'amount' => '5',
  ),
  array(
	  'filename' => '8',
	  'title' => 'CLC small tool bag from the USA',
	  'price' => '7,773 Ft',
	  'desc' => 'Compact tool bag made of durable materials with many handy compartments both inside and out. Spacious interior, sturdy handles and strap. Wide, zippered opening with metal reinforcement for easier access.',
	  'amount' => '2',
  ),
  array(
	  'filename' => '9',
	  'title' => 'Dielectric safety glasses',
	  'price' => '1,784 Ft',
	  'desc' => 'Completely metal-free. Durable with a modern design. Dual-material temple arms with vented structure for airflow. Complies with EN 166 1 FT; clear lens version meets EN170 2C-1.2, ANSI Z87.1+, and tinted version meets EN172 5-3.1, ANSI Z87.1+ U6 L3. Available in clear and tinted.',
	  'amount' => '5',
  ),
  array(
	  'filename' => '10',
	  'title' => 'Mini pry bar (steel)',
	  'price' => '3,683 Ft',
	  'desc' => 'At just 19 cm long, this tool is ideal for tasks in tight spaces. Useful for removing planks, opening boxes, and offers three different methods for nail removal.',
	  'amount' => '5',
  ),
  array(
	  'filename' => '11',
	  'title' => 'Power Core protective gloves',
	  'price' => '16,200 Ft',
	  'desc' => 'All-around mechanical protection. Ergonomic design with padded palms, breathable back, secure grip, flexible wrist, and reinforced knuckles. High abrasion resistance with added protection against punctures, cuts, and tears. Material: 50% polyamide, 40% polyurethane, 3% polyester, 5% PVC, 2% silicone.',
	  'amount' => '3',
  ),
  array(
	  'filename' => '12',
	  'title' => 'Sweater with chest print',
	  'price' => '10,795 Ft',
	  'desc' => 'Smooth exterior, soft fleece interior for cozy comfort even on the job. Reinforced elastic bands at collar, hem, and cuffs keep wind out and shape intact. Classic design enhanced by a bold chest graphic for a dynamic appearance.',
	  'amount' => '2',
  ),
),
'knaufceiling' => array(
  array(
	  'title' => 'Knauf Ceiling gift package',
	  'price' => '',
	  'desc' => ['Textile gloves for ceiling installation', 'Folding ruler', 'Carpenter pencil', 'Engraved Parker pen', 'Planner with Knauf Ceiling logo'],
  ),
),*/
	'krause' => array(
		array(
			'title' => 'Dopplo double-sided step ladder',
			'price' => '19,180 Ft',
			'desc' => ['Lightweight, double-sided aluminum platform ladder with working height up to 3.30 m (8-step version)', 'Robust, impact-resistant steel hinges', '6-point riveted, strong connection between rungs and rails for high stability', 'Slip-resistant, grooved, floor-friendly end caps', 'Tear-proof straps', 'According to EN 131 – 3 standard, only the third step/rung from the top may be used on double-sided ladders'],
		),
	),/*
'merkbau' => array(
  array(
	  'title' => 'Bautool diamond drill bit set',
	  'price' => '44,900 Ft',
	  'desc' => ['Sizes: 20, 35, 40, 51, 67 mm', 'For angle grinders (M14)', 'In a case'],
  ),
  array(
	  'title' => 'Bihui mixer',
	  'price' => '52,900 Ft',
	  'desc' => ['Power: 1200W', 'Mount: M14'],
  ),
),
'prefa' => array(
  array(
	  'title' => 'Clothing package',
	  'price' => '',
	  'desc' => '',
  ),
),
'ravak' => array(
  array(
	  'title' => 'RAVAK toolbox',
	  'price' => '',
	  'desc' => ['With handle and secure latch', 'Top tray with dividers', 'In black color'],
  ),
),
'terran' => array(
  array(
	  'filename' => '1',
	  'title' => 'Terrán gift package',
	  'price' => '',
	  'desc' => ['Mug', 'Jacket'],
	  'amount' => '4',
  ),
),*/
	'tesa' => array(
		array(
			'title' => 'tesa® gift package',
			'price' => '17,000 Ft',
			'desc' => ['1 pc Pevalin hand cleansing wipe', '1 pc Pevalin hand cleansing cream 500ml', '2 pcs tesa® 4352 Universal masking tape 50m x 30mm'],
		),
	),/*
'trilak' => array(
  array(
	  'filename' => '1',
	  'title' => 'PPG Trilak gift package',
	  'price' => '',
	  'desc' => ['Héra T-shirt', 'Héra painter’s trousers', 'Héra baseball cap', 'Voice of Color swatch', '2 pcs new Héra Interior Paint 15L (to be picked up at our Budapest store)', '1 pc Héra Premium Latex 3in1 Primer Paint 10L (to be picked up at our Budapest store)'],
	  'amount' => '2',
  ),
),
'uzin' => array(
  array(
	  'title' => 'UZIN gift package 10 pcs',
	  'price' => '',
	  'desc' => ['1 pc UZIN T-shirt', '1 pc UZIN mug', 'Office pack (notepad, pen, post-it, carpenter pencil, folding ruler)'],
	  'amount' => '10',
  ),
),
'zakanyszerszam' => array(
  array(
	  'filename' => '1',
	  'title' => 'Zákány Toolhouse gift package',
	  'price' => '',
	  'desc' => ['Umbrella', 'Water bottle', 'Pen', 'Toolbox', 'Bosch Pro 35-piece bit and drill set'],
	  'amount' => '1',
  ),
),*/
);






$nyeremenyekCegek = array_keys($nyeremenyek);
/*
$nyeremenyekStandon = array(
	'aco' => array(
		array(
			'title' => 'Exkluzív kivitelű bögre',
			'price' => '',
			'desc' => 'Az ACO standján történő angolakna szereléshez vagy folyóka beépítéshez, illetve adatbázis regisztrációhoz kötött garantált ajándék. A készlet erejéig!',
		),
		array(
			'title' => '10 db Sporttáska',
			'price' => '',
			'desc' => 'Az ACO standjánál angolaknát szerelők vagy folyókát beépítők között utólagosan sorsoljuk ki. Adatbázis regisztrációhoz kötött!',
		),

	),
	'kohazy' => array(
		array(
			'title' => '3 db Schuller Easy mix 1200W habarcskeverő',
			'price' => '40 800 Ft',
			'desc' => 'Utólagos húzásos sorsolással, regisztrációhoz és kérdőív kitöltéséhez kötött!',
		),
		array(
			'title' => '1 db Schuller Easy mix falcsiszoló zsiráf',
			'price' => '78 800 Ft',
			'desc' => 'Utólagos húzásos sorsolással, regisztrációhoz és kérdőív kitöltéséhez kötött!',
		),
		array(
			'title' => '10 db Trilak Voice of Colour színkártya',
			'price' => '24 000 Ft',
			'desc' => 'Utólagos húzásos sorsolással, regisztrációhoz és kérdőív kitöltéséhez kötött!',
		),
		array(
			'title' => '20 db kedvezménykupon',
			'price' => '',
			'desc' => 'Utólagos húzásos sorsolással, regisztrációhoz és kérdőív kitöltéséhez kötött!<br>100 000 Ft feletti vásárlás esetén 10 % kedvezményt biztosít a Kőházy Festékáruházak boltjaiban történő vásárlásra (egyszeri alkalommal, alábbi termékek kivételével: Héra 15 l -es fehér, piros tetős és 15 l-es Gold, Rigips Rimano 0-10, 6-30 és 3-6-os 20 kg-os kiszerelése, akciós és leárazott termékek',
		),
	),
	'trilak' => array(
		array(
			'title' => '10 db PPG Trilak ajándékcsomag',
			'price' => '',
			'desc' => ['Héra póló', 'Héra baseball sapka', 'Voice of Color színkártya'],
		),
	),
	'uzin' => array(

		array(
			'title' => 'UZIN ajándékcsomag 10 db (Utólagos sorsolással, REGISZTRÁCIÓ kitöltéséhez kötött a részvétel)',
			'price' => '',
			'desc' => ['1db UZIN póló', '1db UZIN strandtörülköző', '1db WOLFF Ergostar spatulya', 'Irodacsomag (jegyzettömb, toll, post-it, ácsceruza, collstock)'],
		),
		array(
			'title' => 'WOLFF keverőállomás 1 db (Utólagos sorsolással, REGISZTRÁCIÓ kitöltéséhez kötött a részvétel)',
			'price' => '',
			'desc' => ['WOLFF keverőállomás komplett'],
		),
	),
);


$nyeremenyekStandonCegek = array_keys($nyeremenyekStandon);


*/
$ujdonsagok = array(
	'dufa' => array(
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-dufa-1.webp',
			'title' => 'Düfa Diamond',
			'desc' => '
  <h1>Megérkezett a <strong>düfa Diamond</strong>!</h1>
  <p><em>Egy falfesték kompromisszumok nélkül a Tökéletes otthonért.</em></p>
  <p>A <strong>düfa Diamond</strong> egy kiváló minőségű, káros anyagoktól mentes, környezetbarát falfesték, mely a legújabb technológiai fejlesztéseknek köszönhetően kiemelkedő tulajdonságokkal rendelkezik.</p>
  <ul>
    <li><strong>Magas fehérség</strong> – letisztult, ragyogó felületek, esztétikus megjelenés, akár már egy rétegben is</li>
    <li><strong>Káros anyagoktól mentes összetétel</strong> – VOC-mentes, környezet- és egészségbarát formula</li>
    <li><strong>Ragyogó fehérség, kiemelkedő fedőképesség és tartósság</strong> – hosszú távú védelem, elegáns megjelenés</li>
    <li><strong>Könnyű feldolgozhatóság</strong> – gyors száradás, kiváló fedés és tapadás</li>
    <li><strong>Kiváló páraáteresztő képesség</strong>, ugyanakkor <strong>mosható felület</strong></li>
    <li><strong>Nincs szaghatás</strong> a festéskor – ideális gyerekszobák festésére is</li>
    <li><strong>Ideális választás</strong> lakossági és professzionális felhasználásra egyaránt</li>
	</ul>
  <p>Ez a kiemelkedően tartós beltéri falfesték kifejezetten azok számára készült, akik magas igényeket támasztanak a beltéri falfelületek esztétikájával és ellenállóságával szemben.</p>
  <p>A <strong>düfa Diamond</strong> ideális választás otthonokba, irodákba, közintézményekbe és minden olyan térbe, ahol a <strong>tisztaság</strong>, a <strong>biztonság</strong> és az <strong>esztétika</strong> kiemelt szerepet játszik.</p>
  <p>További információ:<a href="https://dufa-hungary.hu/termek/dufa-diamond-premium-minosegu-belteri-falfestek/" target="_blank" rel="noopener noreferrer"> Düfa Diamond - Prémium minőségű beltéri falfesték - Düfa festékek</a></p>
'
		),

	),
	'blum' => array(
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-18.webp',
			'title' => 'MINIPRESS top easystickkel',
			'desc' => '<strong>MINIPRESS top + EASYSTICK – Digitális pontosság egyszerűen</strong>A MINIPRESS top egy sokoldalú és precíz fúrógép, amely függőleges és vízszintes fúrásokat is lehetővé tesz. Az EASYSTICK digitális ütközőrendszer automatikusan kiszámítja és beállítja a fúrási pontokat az alkatrészméretek alapján – így sablonok, mérés és számolgatás nélkül dolgozhatsz gyorsan és pontosan. A rendszer a DYNALOG szoftverrel is kompatibilis, így gördülékeny a tervezés és kivitelezés.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-17.webp',
			'title' => 'MINIPRESS P',
			'desc' => '<strong>BLUM MINIPRESS P – Maximális hatékonyság sablonok nélkül</strong>A MINIPRESS P stabil és precíz megoldás a bútorvasalatok beépítéséhez. A gyors szerszámcsere, a 9 orsós fúrófej és az állítható távolságok lehetővé teszik a pontos, sablon nélküli fúrást. Intenzív használatra is ideális, egyszerűen kezelhető.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-15.webp',
			'title' => 'ECODRILL',
			'desc' => '<strong>BLUM ECODRILL – Precíz pántfuratok, gyorsan és egyszerűen</strong>Az ECODRILL egy kézi működtetésű, kompakt fúrósablon, amellyel három pontos furat készíthető egyszerre a kivetőpánt számára. Könnyen kezelhető, helyszíni szereléshez és kis műhelyekbe is ideális megoldás.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-4.webp',
			'title' => 'BOXFIX E-M',
			'desc' => '<strong>BLUM BOXFIX E-M – Fiókszerelés profi módon</strong>A félautomata BOXFIX E-M megkönnyíti a MERIVOBOX fiókok pontos összeszerelését. A pneumatikus működés és a beállító elemek gyors és egyforma minőségű munkát tesznek lehetővé, akár egyedi, akár szériagyártásról van szó.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-12.webp',
			'title' => 'Univerzális botos sablon',
			'desc' => '<strong>BLUM Univerzális botos sablon – Pontosság gép nélkül</strong>Ez a sokoldalú, kézi sablon megkönnyíti a BLUM vasalatok – például pántok, talpak, fiók- és frontvezetők – pontos beépítését. Kompakt, állítható kialakítása révén ideális kisebb műhelyekbe vagy helyszíni szereléshez is'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-13.webp',
			'title' => 'BLUM Univerzális egyenes botos sablon – Precíz fúrás bárhol',
			'desc' => '<strong>BLUM Univerzális egyenes botos sablon – Precíz fúrás bárhol</strong>Ez a sokoldalú kézi sablon ideális a korpuszsínek, erőhordozók, talpak és adapterlemezek gyors és pontos fúrásához, akár lapra, akár összeszerelt bútorra dolgozol.
A mélységi skála révén alkalmazható különféle vasalatokhoz, legyen az ráütődő vagy közézáródó megoldás.
A robusztus, mégis könnyű kialakítás hosszú távon is kényelmes munkát tesz lehetővé – pontos, egyszerű, univerzális.
'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-14.webp',
			'title' => 'BLUM Univerzális fúrósablon – Precíz munka, bárhol',
			'desc' => '<strong></strong>Sokoldalú sablon az előlaprögzítők, korlátok, fiókhátlapok, fenéklapok és AVENTOS elemek pontos előfúrásához. Beépített skálájával gyorsan állítható, masszív kialakítása pedig garantálja a pontos, '
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-3.webp',
			'title' => 'Botos sablon kivetőpántrendszerekhez',
			'desc' => '<strong>BLUM Botos sablon – Egyszerű és pontos jelölés</strong>A botos sablon segítségével a kivetőpántok és szerelőtalpak rögzítési pontjai gyorsan és precízen átjelölhetők – akár korpuszon, akár ajtón.
Használata gyorsítja a munkát, és kiküszöböli a hosszas méricskélést.
Állítható ütközője és skálája pontos beállítást tesz lehetővé különböző ráütésekhez
'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-10.webp',
			'title' => 'Szerelőtalp jelölő sablon',
			'desc' => '<strong>BLUM Szerelőtalp jelölő sablon – Precíz jelölés gyorsan</strong>Ez a kis sablon pontos előfúrást biztosít szerelőtalpakhoz és adapterlemezekhez, ideális sorozatgyártáshoz és egyedi bútorokhoz egyaránt.
Jelölés alapján könnyen használható, és akár több sablon is rögzíthető egyszerre a hatékonyság növeléséért.
Tartós acélból készült, így hosszú távon megbízható segédeszköz minden műhelyben.
'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-5.webp',
			'title' => 'Fúrósablon szerelőtalpakhoz',
			'desc' => '<strong>BLUM keresztalakú szerelőtalp sablon – Precíz rögzítés könnyedén</strong>Ez a sablon tökéletes a keresztalakú szerelőtalpak és adapterlemezek (BLUMOTION, TIP-ON) pontos furatainak készítéséhez, akár egyedi, akár sorozatmunka esetén.
Beépített tüske biztosítja a 32 mm-es rendszerfúrás hibátlan illesztését, így gyorsan és egyszerűen végezheted a munkát méricskélés nélkül.
Könnyű, mégis masszív műanyag/acél kialakításával megbízható segédeszköz műhelyben és helyszínen egyaránt.
'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-9.webp',
			'title' => 'Fúrósablon BLUMOTION/TIP-ON szereléshez',
			'desc' => '<strong>BLUM sablon a BLUMOTION egységhez – Precíz kifúrás minden alkalommal</strong>Ez a sablon nélkülözhetetlen segédeszköz a BLUMOTION homlokoldali rögzítési pontjainak pontos kifúrásához, akár az ajtó fogantyú vagy a kivetőpánt oldalán helyezkedik el a fékezőegység.
Ideális az AVENTOS HK top sorozathoz, CLIP top pántokhoz és TIP-ON mechanizmusokhoz.
Jelölés szerinti megmunkálást tesz lehetővé, így a furatok mindig hibátlanul a helyükre kerülnek, tartós műanyag/acél kivitele pedig hosszú távú, megbízható használatot garantál műhelyben és helyszínen egyaránt.
'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-8.webp',
			'title' => 'Korpusz- szögmérő sablon',
			'desc' => '<strong>BLUM Korpusz szögmérő sablon – Pontos szögek, precíz illeszkedés</strong>Ez a könnyű, műanyag korpusz szögmérő sablon gyors és egyszerű eszköz a korpusz szögeinek pontos méréséhez, amely megkönnyíti a megfelelő kivetőpánt kiválasztását, különösen szögeltérő vagy egyedi bútorok esetén. Használata kényelmes mind műhelyben, mind helyszíni felméréskor, így biztosítva a pontos szerelést és tartósságot.'
		),

		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-11.webp',
			'title' => 'Fúrósablon kivetőpánthoz',
			'desc' => '<strong>BLUM többfunkciós sablon – Precíziós megoldás minden rögzítéshez</strong>Ez a sokoldalú sablon egyszerre teszi lehetővé a kivetőpántok oldalsó furatainak (Ø 8 vagy Ø 2,5 mm), az egyenes és kereszt szerelőtalpak, valamint az adapterlemezek (BLUMOTION | TIP-ON ajtókhoz) pontos és gyors előfúrását. A jelölés szerinti megmunkálásnak köszönhetően minden furat hibamentesen, könnyedén elkészíthető, így gyorsítva a munkafolyamatot. Tartós műanyag és acél anyaghasználatával megbízható társ minden bútoripari szerelés során.'
		),

		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-6.webp',
			'title' => 'Fúrósablon SERVO-DRIVE kapcsoló',
			'desc' => '<strong>BLUM kézi sablon SERVO-DRIVE kapcsolókhoz – Pontosság minden fúrásnál</strong>Ez a precíz kéziszerszám ideális a SERVO-DRIVE kapcsoló pontos kifúrásához, használható kézi fúrógéppel vagy akkumulátoros csavarbehajtóval. Alkatrészen és összeszerelt korpuszon egyaránt alkalmazható, gyors és hibamentes munkát biztosít. Tartós alumínium kialakítása megbízható segítőtárs műhelyben és helyszínen.'
		),

		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-2.webp',
			'title' => 'AVENTOS HK top pontozó sablon',
			'desc' => '<strong>BLUM előlaprögzítő sablon – pontos jelölés, egyszerű szerelés</strong>Ez a sablon gyors és megbízható segítséget nyújt az előlaprögzítő vasalatok rögzítőpozícióinak pontos bejelöléséhez. Tartós műanyag/acél anyaga garantálja a hosszú élettartamot és a precíz munkavégzést.'
		),



		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-1.webp',
			'title' => 'AVENTOS termékcsalád',
			'desc' => '<strong>AVENTOS termékcsalád – Innovatív felnyílóvasalatok modern bútorokhoz</strong>Az AVENTOS a BLUM prémium felnyílóvasalat családja, amely könnyű, halk és biztonságos mozgatást biztosít felnyíló és kihúzható bútorajtókhoz, növelve a használati komfortot és esztétikus megjelenést kölcsönözve. Az újdonság, az AVENTOS HKI, kompakt és karcsú kialakításával teljesen integrálható a korpusz-oldalfalba, így a felnyílóvasalat szinte egybeolvad a bútorral. Ez a megoldás minimalista bútorok tervezését teszi lehetővé, maximális formatervezési szabadsággal és prémium minőséggel.'
		),

		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-7.webp',
			'title' => 'Blum kivetőpántok',
			'desc' => '<strong>BLUM kivetőpántok – Precíz illeszkedés és megbízható működés</strong>A BLUM kivetőpántok a bútorajtók legnépszerűbb vasalatai közé tartoznak, melyek precíz, tartós és könnyen beállítható csukódást biztosítanak. Széles típus- és kiválasztékuk révén minden bútorfronthoz és nyitási módhoz kínálnak ideális megoldást. A modern onyx fekete színváltozat különleges dizájnt és exkluzív megjelenést kölcsönöz a bútoroknak, miközben a halk működés és hosszú élettartam továbbra is garantálja a kiváló minőséget és kényelmet.'
		),

		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-16.webp',
			'title' => 'BLUM Fiókrendszerek',
			'desc' => '<strong>BLUM fiókrendszerek – Precíz megmunkálás, könnyű szerelhetőség, hosszú élettartam</strong>A MERIVOBOX robusztus kivitele megkönnyíti a szerelést és hosszú távú stabilitást biztosít, a TANDEMBOX csendes, sima működése a finom beállítások révén garantált, míg a LEGRABOX letisztult, modern designja egyszerűsíti a beépítést és esztétikus végeredményt nyújt. Minden rendszer az asztalos munkáját támogatja a könnyű szerelhetőség és tartósság révén.'
		),

		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-0.webp',
			'title' => 'AMPEROS',
			'desc' => '<strong>AMPEROS – BLUM újdonság a bútorvilágítás forradalmasítására</strong>Az AMPEROS AC elegáns és praktikus megoldás az elektromos készülékek bútorban történő áramellátására. A beépített aljzatnak köszönhetően az áramforrás ott van, ahol szükség van rá, de nem látható, mivel a kábelvezetékkel együtt egy fiók vagy polckihúzás alatt van elrejtve.'
		),

		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-19.webp',
			'title' => 'REVEGO',
			'desc' => '<strong>BLUM REVEGO – Láthatatlan megoldás, maximális hatás</strong>A REVEGO egy teljesen integrált pocketrendszer, amellyel a nagyméretű frontok egy mozdulattal oldalra siklanak és eltűnnek a korpuszban. Ezzel a gyárilag előkészített megoldással a szerelés és beépítés is maximálisan támogatva van. Innovatív megoldás azoknak az asztalosoknak, akik valami igazán különlegeset kínálnának.'
		),









	),
	'happyfloor' => array(
		array(
			'image' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-happyfloor-1.webp',
			'title' => 'Multi Cover Air Plus',
			'desc' => 'A Multi Cover Air Plus légáteresztő, vízzáró védőfólia, amely lehetővé teszi a friss burkolatok – például fugázott járólapok – biztonságos lefedését már a száradási idő alatt is. Csúszásgátló felülete biztonságossá teszi a munkaterületet, miközben megakadályozza a szennyeződések és sérülések kialakulását. Különösen ajánlott, ha a munkavégzés nem állhat meg a burkolás után.'
		),
		array(
			'image' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-happyfloor-2.webp',
			'title' => 'Uni Cover',
			'desc' => 'Az Uni Cover egy átlátszó, UV-álló öntapadó fólia, amely ideiglenes védelmet nyújt üvegfelületeknek, ajtó- és ablakkereteknek, rozsdamentes acél elemeknek. Gyorsan telepíthető, visszaszedhető, és nem hagy nyomot maga után. Tökéletes megoldás nyílászárók, korlátok és dekorprofilok védelmére építkezés vagy felújítás idején. Háromféle méretben, illetve UV stabil -28 vagy 180 nap- kiszerelésben kapható.'
		),
		array(
			'image' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-happyfloor-3.webp	',
			'title' => 'Multi Board',
			'desc' => 'A Multi Board egy ultrakönnyű műanyag védőlap, mely ideális falak, padlók, lépcsők, nyílászárók ideiglenes lezárásához és védelméhez. A Multi Board gyorsan lerakható, tetszés szerint méretre vágható egy egyszerű késsel, de kézzel is megtörhető, összehajtható.'
		),
		array(
			'image' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-happyfloor-4.webp',
			'title' => 'Frame Cover',
			'desc' => 'A Frame Cover egy vastag, ütéscsillapító habvédő ajtó- és ablaktokokhoz, illetve korlátokhoz. Egyszerűen rögzíthető, nem igényel ragasztást, mégis stabilan a helyén marad. Kiváló megoldás a sérülékeny élek és keretek védelmére burkolási és festési munkálatok során.'
		),
		array(
			'image' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-happyfloor-5.webp',
			'title' => 'Floor Cover',
			'desc' => 'A Floor Cover egy szupererős fólia padlók és lépcsők ideiglenes védelmére. Az átlátszó LLDPE-fólia speciálisan szilárd felületekhez kifejlesztett, vízbázisú ragasztóréteggel rendelkezik, így tökéletesen tapad.'
		),
		array(
			'image' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-happyfloor-6.webp',
			'title' => 'Dura Cover',
			'desc' => 'A Floor Cover egy szupererős fólia padlók és lépcsők ideiglenes védelmére. Az átlátszó LLDPE-fólia speciálisan szilárd felületekhez kifejlesztett, vízbázisú ragasztóréteggel rendelkezik, így tökéletesen tapad.'
		),
		array(
			'image' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-happyfloor-7.webp',
			'title' => 'Sticky Mat',
			'desc' => 'A Sticky Mat egy öntapadós bejárati szőnyeg, ami felfogja a port, koszt, szennyeződéseket cipőkről, bakancsokról, kerékgumiról és mindenféle görgő kerékről. A felső elszennyeződött réteget egy egyszerű mozdulattal lehúzhatjuk, hogy egy új és tiszta tapadófelületet biztosítsunk. A rétegek számozottak, így látható hány tiszta lap áll még a rendelkezésünkre. Az alsó felületén egy öntapadós réteg biztosítja, hogy a szőnyeg fixen egyhelyben maradjon'
		),
		array(
			'image' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-happyfloor-8.webp',
			'title' => 'Dust Door',
			'desc' => 'A porfogó ajtó egy szuper erős, átlátszó fólia az ajtónyílások ideiglenes tömítésére. Az ajtó erős fóliából és öntapadósan felhelyezhető cipzárból áll. Így a cipzár szabadon választva bárhova felhelyezhető az áthaladás helyének ideális kialakítása érdekében.'
		),
	),
	/*
		'aco' => array(
			array(
				'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-aco-1.webp',
				'title' => 'ACO Therm® műanyag pincebevilágító akna',
				'desc' => 'A pinceépítéshez megfelelő ACO termékekkel a funkcionalitás és a biztonság igény szerint kombinálható, és a szabványoknak megfelelően integrálható lakóépületi projektjébe. A különböző méretű ACO Therm® angolakna rendszerekkel lehetőséget kínálunk arra, hogy a pincében világos, kellemes közérzetet biztosító oázis jöjjön létre. Az ACO Therm® angolaknák víznyomásmentesen, az ACO Therm® Block-on pedig akár hőhidak nélkül, fúrás nélkül is felszerelhetőek.'
			),
			array(
				'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-aco-2.webp',
				'title' => 'ACO Slimline kültéri folyóka',
				'desc' => 'Az ACO Slimline egyszerre diszkrét és esztétikus megjelenésű termék. A mindössze 6 cm keskeny Slimline vízelvezető rendszer tökéletes megoldás a térkővel borított felületek vizének hatékony és elegáns elvezetéséhez.'
			),
		),
		'atlas' => array(
			array(
				'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-atlas-1.webp',
				'title' => 'ATLAS GEOFLEX',
				'desc' => ['Flexibilis gél ragasztó, rétegvastagság 2-15 mm', 'Kerámia és  kőlapokhoz', 'Függőleges csúszásmentesség - teljes terülés a járólap alatt', 'Járható és fugázható már 12 óra eltelte után', 'Változatos felhasználási lehetőség - középületekben, mosodákban, zuhanyzókban, teraszokon', 'Használati hőmérséklet 5 és 35°C között', 'Anyagfogyasztás - 30x30 cm-es burkolólap esetén: 2 kg/ m2-től']
			),
			array(
				'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-atlas-2.webp',
				'title' => 'ATLAS GEOFLEX ALB',
				'desc' => ['Flexibilis gél ragasztó, fehér, rétegvastagság 2-15 mm', 'Márvány- és természetes kőlapokhoz ajánlott', 'Minden típusú burkolólaphoz, beleértve kerámia, porcelán burkolólapok,  üvegmozaik, sőt a fakulásra/foltosságra érzékeny burkolólapokat is', 'Nehezen kezelhető alapfelületekre, mint például - beton, terrazzo, régi burkolólapok, OSB-, stb.', 'Változatos felhasználási lehetőség - középületekben, mosodákban, zuhanyzókban, teraszokon', 'Használati hőmérséklet 5 és 35°C között', 'Anyagfogyasztás - 30x30 cm-es burkolólap esetén: 2 kg/ m2-től']
			),
			array(
				'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-atlas-3.webp',
				'title' => 'ATLAS GEOFLEX EXPRESS',
				'desc' => ['Flexibilis gél ragasztó, gyors kötésű, rétegvastagság 2-15 mm', 'Járható és fugázható már  2 óra elteltével', 'Kerámia burkolólapok  vagy természetes kő, porcelán járólapok és mozaik lapok ragasztására', 'Használható kül- és beltérben, bejárati helyiségekben, fürdőszobákban, erkélyeken és teraszokon', 'Tökéletes terülés a burkolólapok alatt és függőleges csúszásmentesség nagy méretű lapok esetén is', 'Anyagfogyasztás - 30x30 cm-es burkolólap esetén: 2 kg/ m2-től']
			),
			array(
				'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-atlas-4.webp',
				'title' => 'ATLAS GEOFLEX ULTRA',
				'desc' => ['Flexibilis gél ragasztó, deformálódásra képes, 2-15 mm', 'Bármilyen tipusu es méretű burkolólaphoz-  kerámia-, kő-, üveg burkolólapok, stb.', 'Nagyon nezen kezelhető, kritikus  alapfelületekre: régi burkolólapok, terrazzo- , gipszkarton-, fa- OSB lapok, stb.', 'Korlátlan felhasználási lehetőségek - padlofűtéses felületekre, teraszokra, medencékhez, stb', 'Csúszásmentesség nagy formátumu burkólapok esetén, az  5 m2 – nél nagyobb burkolólapok esetén is', 'Anyagfogyasztás - 30x30 cm-es burkolólap esetén: 2 kg/ m2-től']
			),
			array(
				'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-atlas-5.webp',
				'title' => 'ATLAS GEOFLEX ULTRA ALB',
				'desc' => ['Flexibilis gél ragasztó, fehér, deformálódásra képes, 2-15 mm', 'Bármilyen tipusu és méretű burkolólaphoz- kerámia, kő-, üveglapok, stb.,  beleértve a fakulásra/foltosságra érzékeny nedvszívó burkolólapokat is', 'Nehezen kezelhető, kritikus alapfelületekre: régi kerámialapok, terrazzo, gipszkarton lapok, fa alpu lapok, OSB, stb.', 'Korlátlan felhasználási lehetőségek - padlofűtéses felületekre, teraszokra, medencékhez, stb', 'Csúszásmentesség nagy formátumu burkólapok esetén, az  5 m2 – nél nagyobb burkolólapok esetén is', 'Anyagfogyasztás - 30x30 cm-es burkolólap esetén: 2 kg/ m2-től']
			),
			array(
				'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-atlas-6.webp',
				'title' => 'ATLAS PLUS S2 HYDRO',
				'desc' => ['Rendkívül deformálható ragasztó és vízszigetelő, 2-10mm', 'Kül- és beltérben is használható kritikus alapfelületeken', '2 az 1-ben - S2 osztályú ragasztó és vízszigetelő anyag egyetlen szakaszban.', 'Korlátlan felhasználási lehetőségek – ivóviz tartályok, medencék, homlokzatok, ipari belterek, extrém rezgésnek és igénybevételnek kitett felületek stb.', 'Járható  már 24 óra eltelte után', 'Anyagfogyasztás - 30x30 cm-es burkolólap esetén: 2 kg/ m2-től']
			),
			array(
				'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-atlas-7.webp',
				'title' => 'ATLAS GTA',
				'desc' => ['Készre gyártott polimer glett, tökéletesen sima, hófehér', 'Felhordható glettelővel, hengerrel vagy gépileg, még nedvest a nedvesre is,  egyszerűen, egyenletesen, gyorsan és fröccsenés mentesen', 'Használható gipszkarton lapok fugázására erősítő szalaggal', 'Ideális konzisztencia felhordáshoz és profilozáshoz, tökéletes simítás', 'Por hatás nélkül - tiszta és biztonságos „nedves” csiszolás', 'Meghosszabbított vödöridő - 12 hónap', 'Kézi vagy gépesített csiszolás']
			),
			array(
				'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-atlas-8.webp',
				'title' => 'ATLAS GRUNT NKP',
				'desc' => ['Gyorsan száradó, multifunkciónális gél típusú alapozó', 'Kül- és beltéri nedvszívó aljzatokhoz: vakolatokhoz, estrichkekhez, falakhoz, glettekhez,stb.', 'Gél kozisztencia,  nem hagy nyomokat, fröccsenés és  cseppmentes', 'Bármilyen típusú aljzathoz használható – nincs szükség higitásra, előkészitésre', 'Javítja a tapadást és erősíti az aljzatot', '35°C alatti hőmérsékleten történő alkalmazásokhoz', 'Anyagfogyasztás - 0,05-2 kg/m2']
			),
			array(
				'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-atlas-9.webp',
				'title' => 'ATLAS WODER E ',
				'desc' => ['Gyorsan száradó folyékony egykomponensű vizszigetelő membrán', 'Vízszigetelő anyag  kerámia  burkolólapok alá  vagy különféle típusú felületkezeléseknél, szabványos vagy nehezen kezelhető aljzatokon: fa, OSB, fém, gipszkarton', 'Használhazó fürdőszobákban, zuhanyzókban, mosodákban, szaunákban, konyhákban, erkélyeken, stb.', 'Kerámia burkolólapok ragasztása 2 óra után fürdőszobákban és konyhákban  és 4 óra után az erkélyeken', 'Nagyon rugalmas, repedésálló, különleges tapadású', 'Meghosszabbított vödör idő - 12 hónap', 'Anyagfogyasztás - 1kg/m2 (fürdőszobák, konyhák ) vagy 2kg/m2 (erkélyek, zuhanyzók, teraszok)']
			),
			array(
				'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-atlas-10.webp',
				'title' => 'CESAL AUTO-NIVEL RAPID',
				'desc' => ['Gyors kötésű önterülő esztrich/aljzatkiegyenlitő 3-30 mm vastagság', 'Sima alapfelület burkoló anyagok alatt, mint pl. kerámia burkolólapok,  linóleum, parketta, padlók, epoxi padlók, stb.', 'Ásványi alapu aljzatok javításához és kiegyenlítéséhez, ideális padlofűtéses felületekre', 'Csökkentett lineáris zsugorodás', 'A felület mindössze 4 óra elteltével járható', 'Anyagfogyasztás - 16,5 kg / m2/ 10 mm rétegvastagság esetén']
			),
		),*/
	'bramac_villas' => array(
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-bramac_villas-divoroll-standard.webp',
			'title' => 'Bramac Divoroll Standard tetőfólia',
			'desc' => 'Megbízható, belépő szintű páraáteresztő tetőfólia, új megjelenéssel és 120 g/m² súllyal. Költséghatékony megoldás, 15 év garanciával. Alkalmazható tetőcserép, pala, illetve átszellőztetett profilozott fémlemez tetők esetén, legyen szó beépített tetőtérről vagy hideg tetőszerkezetről.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-bramac_villas-divoroll-standardp.webp',
			'title' => 'Bramac Divoroll Standard+ tetőfólia',
			'desc' => 'Páraáteresztő tetőfólia, amely szilárd aljzatra - például deszkázatra - is biztonságosan fektethető. Kiváló ár-érték arányú termék, magas szintű műszaki teljesítmény mellett, 15 év garanciával. Alkalmas tetőcserép, pala vagy átszellőztetett profilozott fémlemez fedésekhez, beépített tetőtérrel rendelkező vagy hideg tetőszerkezetek esetén is. Felületsúlyának köszönhetően szilárd aljzaton is alkalmazható.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-bramac_villas-divoroll-standardp-2s.webp',
			'title' => 'Bramac Divoroll Standard+ 2S tetőfólia',
			'desc' => 'Gazdaságos választás a páraáteresztő tetőfóliák között, kiváló ár-érték aránnyal és megbízható műszaki jellemzőkkel, 15 év garanciával. Alkalmas tetőcserép, pala vagy átszellőztetett profilozott fémlemez fedéshez, beépített tetőtérrel rendelkező és hideg tetők esetén egyaránt. Az integrált dupla ragasztósáv gyorsabb és biztonságosabb kivitelezést tesz lehetővé, emellett növeli a vízzárást az átlapolásoknál.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-bramac_villas-divoroll-duom-2s.webp',
			'title' => 'Bramac Divoroll DUO MAXIMUM 2S tetőfólia',
			'desc' => 'A BMI új, egyedi fejlesztésű magastetős alátétfóliája. Csúcskategóriás dupla védelemmel, 200 g/m2 felületsúllyal. A Duo két vízszigetelő réteget jelent, amely egyesíti az időjárási körülményeknek ellenálló monolitikus felső réteg és a beágyazott mikroporózus filmréteg előnyös tulajdonságait, ezáltal nyugalmat biztosít minden tetőfedési megoldáshoz. A Duo Maximum tetőfóliára a kiterjedt szigorú tesztelés és a hosszú távú valós tesztelés eredményeképpen 30 év funkcionális garanciát vállalunk.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-bramac_villas-divoroll-hyper-2s.webp',
			'title' => 'Bramac Divoroll HYPER 2S tetőfólia',
			'desc' => 'Speciális reflektív, páraáteresztő magastetős alátétfólia, amely egy megerősített univerzális alsó réteget kombinál fémbevonatos lélegző fóliával külön középső rétegként, amely egyszerre visszatükrözi a napsugarakat és hűti a tetőt. Ez két fő előnnyel jár: a metalizált felület csökkenti a fólia korróziójának veszélyét, másodszor pedig a felület csökkenti a beépítés közbeni vakító hatást, továbbá 2-3 fokkal csökkenti a fólia alatti hőmérsékletet.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-bramac_villas-divoroll-topp-2s.webp',
			'title' => 'Bramac Divoroll TOP PLUS 2S tetőfólia',
			'desc' => 'Extra robusztus kivitel, 230 g/m² felületsúly, speciális ragasztósávval, hálóerősítéssel. A Bramac Divoroll Top Plus hatékony megoldást kínál alacsony hajlásszögű és összetett tetők esetén. A Divoroll Top Plus egyedi kialakítása az extra vízlepergető, hidrofobizált felülettel és egy speciális dupla integrált ragasztósávval az átfedésekhez megakadályozza a kapilláris vízmozgásokat.	'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-bramac_villas-divoroll-kompaktp-2s.webp',
			'title' => 'Bramac Divoroll KOMPAKT+ 2S tetőfólia',
			'desc' => 'Robusztus tetőfólia, dupla ragasztósávval, 145 g/m² súllyal. Alkalmas tetőcserép, pala vagy átszellőztetett profilozott fémlemez tetőkhöz beépítve, beépített tetőtér és hideg tetők esetén egyaránt. Az integrált dupla ragasztósáv gyorsabb kivitelezést tesz lehetővé.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-bramac_villas-divoroll-universalp-2s.webp',
			'title' => 'Bramac Divoroll UNIVERSAL PLUS 2S tetőfólia',
			'desc' => 'Megbízható, 4 rétegű, megemelt felületsúlyú tetőfólia, ami ideális választás szakemberek számára. Kiemelkedő biztonságot nyújt az extra erős merevítőrácsnak és a víztaszító, hidrofobizált felületnek köszönhetően. Beépített dupla ragasztósávja gyorsabb és hatékonyabb kivitelezést tesz lehetővé. A nagy teljesítményű flíz fokozott védelmet biztosít a csapadék ellen, míg az integrált hálóerősítés növeli a fólia mérettartását, ellenállóbbá téve azt a nyúlással szemben.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-bramac_villas-wakaflex.webp',
			'title' => 'Wakaflex kémény- és falszegély',
			'desc' => '5m-es tekerccsel a helyszínen nagyon gyorsan kialakítható bármilyen kémény szegélyezése, bármilyen tetőfedő anyaggal a falcsatlakozás, nem szükséges bádogos munka!',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-bramac_villas-figaroll.webp',
			'title' => 'FigaRoll kúpalátét',
			'desc' => 'Oldalsávja 50%-ban nyújtható, gyorsan és biztonságosan zárja le a tetőcserepek és a kúpcserepek csatlakozását, és nagyon hatékony kiszellőzést biztosít magas fokú vízzárás mellett.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-bramac_villas-icopal.webp',
			'title' => 'Icopal Universal WS POCB vízszigetelő lemez',
			'desc' => 'Egy rétegben alkalmas az extenzív és az intenzív zöldtetők kialakítására is, így olcsóbb és gyorsabb tetőmegoldás alakítható ki. Nincs szükség a lemez lángolására, csak az átlapoló sávot kell hegeszteni. FLL minősítésű.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-bramac_villas-termik.webp',
			'title' => 'TERMIK TOP 5 Speed SYNTAN® SBS zárólemez bitumenes lemez felújításhoz páracsatornával',
			'desc' => 'Régi tetők bitumenes felújítása 1 rétegben megoldható. Nincs szükség filces alátét és zárólemezre, egy munkafolyamattal kivitelezhető a pára elvezetése és a vízszigetelés is.',
		),
	),
	'butorvonal' => array(
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-butorvonal-hettich-vasalat.webp',
			'title' => 'Hettich AvanTech YOU – világítással',
			'desc' => 'Az AvanTech YOU prémium fiókrendszer rendkívül vékony, 13 mm-es oldalfallal, rejtett, precíz állíthatóságot biztosító mechanikával, valamint egyedülálló világítási megoldással rendelkezik. A LED-profil diszkrét, elegáns megjelenést kölcsönöz a fióknak, miközben a rendszer teljesen vezetékmentesen, akkumulátorral működik. A világító profil hozzájárul a bútor magasabb esztétikai értékéhez, különösen a prémium szegmensben.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-butorvonal-hettich-furnspin.webp',
			'title' => 'Hettich FurnSpin',
			'desc' => 'A FurnSpin innovatív bútormozgatási megoldás, amely lehetővé teszi a bútorfront 180 fokos elfordítását, így a szekrények új funkciót és megjelenést nyernek. A rendszer új lehetőségeket kínál különösen az egyedi belsőépítészeti megoldások, valamint a multifunkciós terek kialakítása során.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-butorvonal-hettich-vasalat-3.webp',
			'title' => 'TopLine és WingLine ajtórendszerek',
			'desc' => 'A toló- és harmonikaajtók területén a Hettich a megbízható, jól ismert TopLine és WingLine rendszereket mutatja be új konfigurációkban. A TopLine ideális választás nagy méretű, modern tolóajtókhoz, míg a WingLine harmonikarendszer különösen kis helyeken kínál rugalmas megoldást, kiemelkedő stabilitás és halk működés mellett.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-butorvonal-kessebohmer-freeslim.webp',
			'title' => 'Kesseböhmer FREEslim',
			'desc' => 'A FREEslim a világ egyik legvékonyabb flap-vasalata, mely mindössze 8 mm vastag PowerPad mechanikájával forradalmasítja a felsőszekrények nyitását. Moduláris felépítése lehetővé teszi a különböző nyitási típusok (lenyíló, felnyíló, harmonika) testre szabását. Kiválóan alkalmas minimál dizájnú konyhákba és fürdőszobákba.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-butorvonal-kessebohmer-chefstable.webp',
			'title' => 'Kesseböhmer ChefsTable',
			'desc' => 'A ChefsTable professzionális konyhai kiegészítő, amely lehetővé teszi nagyobb gépek (például robotgépek, kávéfőzők) ergonomikus, forgatható tárolását és egyszerű előhívását a pult alatti részből. Az innovatív megoldás jelentős mértékben hozzájárul a konyhai munkafolyamatok hatékonyságához, miközben letisztult, praktikus tárolást biztosít.',
		),
	),
	/*
	'cemix' => array(
		array(
			'title' => 'Agyag alapvakolat',
			'desc' => 'Durva agyag alapvakolat, 2 az 1-ben falazáshoz és vakoláshoz, a természetes és élhető komforthoz fenntartható anyagokkal. Alkalmas a modern és történeti épületekben való alkalmazásra, ökológiai és hagyományos építészetben előforduló falazatokra.',
		),
		array(
			'title' => 'Gépi agyagvakolat',
			'desc' => 'Durva gépi agyagvakolat, ami tudja mindazt amit a durva agyagvakolat, de megkönnyíti a kivitelező munkáját a gépi alkalmazhatóság által, időt és pénzt spórolva az építtetőnek.',
		),
		array(
			'title' => 'Agyag simítóvakolat',
			'desc' => 'Finom agyag simítóvakolat, az egyenletes falképhez. A vakolat záró rétegeként akár glettelés nékül is festhető, de a még simább felület érdekében kiválóan glettelhető.',
		),

	),*/
	'ceresit' => array(
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-ceresit-cn39.webp',
			'title' => 'Ceresit CN 39 aljzatkiegyenlítő',
			'desc' => 'A hazai piacon most megjelenő Ceresit CN 39 olyan speciális, gyorskötésű, cementbázisú kiegyenlítőhabarcs trasszadalékkal, amely alkalmas lejtésképzésre vagy akár oldalfalon szintkülönbség kiegyenlítésére is, bel- és kültéren egyaránt. Trasszadalékot tartalmaz, könnyedén formázható, 3-30 mm rétegvastagságban. Biztonságos és repedésmentes végeredményt biztosít. További információ: ',
			'more' => ['href' => 'https://www.ceresit.hu/termekek/padloburkolas/aljzatkiegyenlites/aljzatkiegyenlito-egyeb/termekek.html/ceresit-cn-39/SAP_0201TCC013Y8.html', 'title' => 'Ceresit CN 39 - Ceresit']
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-ceresit-ce60.webp',
			'title' => 'Felhasználásra kész Ceresit CE 60 fugázó',
			'desc' => 'A Ceresit bemutatja a forradalmian új, felhasználásra kész Ceresit CE 60 fugázóanyagot, amely a polimer diszperzió egyedülálló kombinációján alapul és ezáltal új szintre emeli a fugázást. Nincs szükség vízre a keveréshez, ezáltal időtakarékosabb a felhordás. Abszolút egységes, tartós eredményt és 100%-os színstabilitást nyújt. Nincs többé elszíneződés és kifakult fuga! Elfelejthetjük az egyhangú fugaszíneket és felületet, valamint a szennyeződéseket! Tökéletes választás bármilyen beltéri felhasználásra, minden csempe- és természetes kő típushoz. További információ:',
			'more' => ['href' => 'https://www.ceresit.hu/hu/innovaciok/ce60-hasznalatra-kesz-fuga.html', 'title' => 'CE 60 Az Ideális Fugázó Használatra Kész - Ceresit']
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-ceresit-9.webp',
			'title' => 'Ceresit Homlokzattisztító rendszer',
			'desc' => 'A homlokzat megjelenését több minden károsíthatja: például az úgynevezett városi szennyeződések (por, szmog), szerves eredetű szennyeződések, valamint algásodást, gombásodást okozó spórák. Ha ezek előfordulnak a homlokzaton, akkor a Ceresit homlokzattiszító rendszer termékeinek használatával hosszú távra megvédheti a vakolatot és újra esztétikus megjelenést varázsolhat! További információ: ',
			'more' => ['href' => 'https://www.ceresit.hu/innovaciok/homlokzat-tisztitasa-es-felujitasa.html', 'title' => 'Homlokzat tisztítása és felújítása - Ceresit']
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-ceresit-1.webp',
			'title' => 'Ceresit CL 51 kenhető szigetelőfólia',
			'desc' => 'A Ceresit CL 51 1-K kenhető szigetelőfólia tökéletes szigetelést biztosít a kerámia burkolatok alatt a párás és nedves belső terekben. A Ceresit CL 152 hajlaterősítő szalaggal kombinálva ideális vízszigetelő megoldást nyújt a legkülönfélébb aljzatokhoz. Előnyös tulajdonsága, hogy a csomagolás új, hosszúkás formájának köszönhetően még egyszerűbbé teszi a teddy hengerrel történő felhordást. Az új ECO vödör ráadásul 50%-ban újrahasznosított műanyagból készült. További információ:',
			'more' => ['href' => 'https://www.ceresit.hu/innovaciok/belteri-vizszigetelo-megoldas.html', 'title' => 'Ceresit vízszigetelő megoldás - Ceresit']
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-ceresit-3.webp',
			'title' => 'Ceresit CT 76 Solar Protect fedővakolat',
			'desc' => 'A Ceresit CT 76 SOLAR PROTECT UV Protect technológiával elsőrangú megoldást kínál a napsugárzás romboló hatásai ellen. A CT 76 a szilikon és az elasztomer diszperzió optimális kombinációja, amely kiváló rugalmasságot, magas páraáteresztést, ellenállást és alacsony mértékű vízfelvételt biztosít. További információ: ',
			'more' => ['href' => 'https://www.ceresit.hu/innovaciok/ceresit-ct-76---a-vakolat-vedelmezje.html', 'title' => 'Ceresit CT 76 - A vakolat védelmezője - Ceresit']
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-ceresit-4.webp',
			'title' => 'Ceresit CT 77 mozaik lábazati vakolat',
			'desc' => 'A Ceresit CT 77 prémium mozaikvakolat továbbfejlesztett formulája 48 színárnyalata és kiváló tartóssága minden igénynek megfelel. Foltmentes száradás, jobb ellenállás az UV-sugárzásnak – és az 5 legnépszerűbb szín már előre bekevert kiszerelésben! További információ:',
			'more' => ['href' => 'https://www.ceresit.hu/innovaciok/mozaik-vakolat.html', 'title' => 'Új CT77, Prémium mozaik vakolat - Ceresit']
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-ceresit-ct84.webp',
			'title' => 'Ceresit CT 84 Express PLUS ragasztóhab',
			'desc' => 'A Ceresit CT 84 EXPRESS PLUS poliuretán ragasztóhab gyors és egyszerű hőszigetelést tesz lehetővé. Alkalmazható polisztirol és kőzetgyapot táblákhoz egyaránt, -10°C felett és magas páratartalom esetén is, kifejezetten javasolt alacsony hőmérséklet esetén. További információ: ',
			'more' => ['href' => 'https://www.ceresit.hu/innovaciok/ceresit-ct-84-express-plus.html', 'title' => 'Ceresit CT 84 Express Plus - Ceresit']
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-ceresit-6.webp',
			'title' => 'Ceresit CF 850 és CF 920 vegyi dübel',
			'desc' => 'A Ceresit CF 850 és CF 920 vegyi dübelek kétkomponensű, gyorsan kötődő injektálóhabarcsok, amelyek reaktív gyanta alapúak, sztirolmentes rögzítéshez alkalmasak. A Ceresit vegyi dübelek legfontosabb jelentősége, hogy nagyon erős kötéseket képeznek, erősebbeket, mint maga az alapanyag. Mivel a módszer kémiai kötésen alapul, az alapanyagra nem hat terhelési feszültség, mint a dilatációs típusú rögzítők esetében. Ezért ideális megoldást jelentenek nagy terhelésű alkalmazásokhoz, peremhez közeli rögzítéshez, valamint ismeretlen minőségű vagy alacsony nyomószilárdságú betonban való felhasználáshoz. További információ: <a href="https://www.ceresit.hu/hu/hirek-es-innovaciok/innovaciok/a-vegyi-dubel-ereje.html?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018" target="_blank"></a>',
			'more' => ['href' => 'https://www.ceresit.hu/innovaciok/a-vegyi-dubel-ereje.html', 'title' => 'A vegyi dübel ereje (CF 850, CF 920) - Ceresit']
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-ceresit-7.webp',
			'title' => 'Ceresit CE 79 és CE 89 epoxi fugázók',
			'desc' => 'HOSSZANTARTÓ SZÍNEK: Nincs sókivirágzás. Megakadályozza a színező pigmentek szivárgását, a repedéseket és a zsugorodásokat.<br>ERŐS MECHANIKAI ELLENÁLLÁS: Ideális nagyforgalmú helyekhez, valamint nehéz gépek által igénybe vett területekhez (alkalmas úszómedencékhez, élelmiszeripari üzemekhez, gyógyszertárakhoz,autómosókhoz stb.).<br>KÖNNYŰ FELHASZNÁLHATÓSÁG: Kiváló bedolgozhatóság: könnyedén alkalmazható falakon és padlón egyaránt. Könnyű tisztítás: a maradékanyag szivaccsal eltávolítható. Meggátolja a burkolólapok elszíneződését. További információ:',
			'more' => ['href' => 'https://www.ceresit.hu/innovaciok/epoxy-fuga-forradalom.html', 'title' => 'Epoxy Fuga Forradalom - Ceresit']
		),
		/*array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-ceresit-10.webp',
			'title' => 'Ceresit CT 110 homlokzatfesték',
			'desc' => 'Az új Ceresit CT 110 Solar Protect homlokzatfesték a legkorszerűbb összetevők optimális kombinációja, amely kiemelkedő teljesítményt és ellenállóképességet biztosít: 3x jobb színtartósság, tartós színmegújítás, kiváló fedőképesség, intenzív és ragyogó színárnyalatok. További információ: <a href="https://www.ceresit.hu/hu/innovaciok/ct110-solar-protect.html?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018" target="_blank">Epoxy Fuga Forradalom - Ceresit</a>',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-ceresit-2.webp',
			'title' => 'Ceresit CT 49 homlokzatfesték',
			'desc' => 'A Ceresit CT 49 nanoszilikon homlokzatfesték Silix XD® formulával extra tartósságot, alacsony vízfelvételt, öntisztítást és szennyeződésekkel szembeni védelmet nyújt. Még tartósabb védelem a ház homlokzatának! További információ: <a href="https://www.ceresit.hu/hu/termekek/hoszigetelo-rendszerek/homlokzati-vakolatok/homlokzatfestekek/ceresit-ct-49-szilikon-alapu-festek.html?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018" target="_blank">CT 49 Szilikon alapú festék - Ceresit</a>',
		),*/
	),
	'festool' => array(
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-festool-dfc500.webp',
			'title' => 'DFC 500 dübelmaró',
			'desc' => 'A DOMINO dübelmaró ergonomikus lapátfogantyúval ellátott akkumulátoros változata kényelmesebb munkavégzést tesz lehetővé vezeték nélkül. Segítségével a DOMINO dübelek pontos illeszkedéssel vagy hézaggal bemarhatók. Az egyedülálló ovális forma révén rendkívül stabil és csavarodásálló a kötés már az első dübeltől kezdődően.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-festool-df500r.webp',
			'title' => 'DF 500 R DOMINO rendszer',
			'desc' => 'A DOMINO rendszer két különböző fafajtából készült dübelekből áll, beltéri és kültéri használatra. A gép tartozékai, mint például a kerek és a lécütköző, kibővítik a felhasználási lehetőségeket.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-festool-ofkc500.webp',
			'title' => 'OFKC 500 élmaró',
			'desc' => 'Az akkumulátornak köszönhetően zökkenőmentes munkafolyamatokra és az élmaró könnyebb kezelésére számíthat összegabalyodott kábelek nélkül. Az nyíláshoz tökéletesen illeszkedő marószerszámok megakadályozzák az anyagba marás közbeni lebillenést.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-festool-ofk500.webp',
			'title' => 'OFK 500 élmaró',
			'desc' => 'Az élmarón pontosan szabályozható a magasságállítás, 0,1 mm-es léptékben. A közvetlenül az orsón elhelyezkedő marószerszám növeli a kifutási pontosságot és tiszta marási eredményt garantál.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-festool-mfkc700.webp',
			'title' => 'MFKC 700 akkus modul élmaró',
			'desc' => 'Az akkus modul élmaró univerzális interfészének köszönhetően a felhasználási céltól függően különböző maróasztalokat használhat: lekerekítés, élletörés, profilozás, falcolás, hornyolás és szintbemarás.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-festool-mfkc700ka.webp',
			'title' => 'MFKC 700 KA akkus modul-élmaró',
			'desc' => 'Az akkus modul-élmaró emelt támasztóasztalát a túlnyúló élekhez alakították ki, amely ideális szintbemaráshoz vagy kilógó élek lekerekítéséhez. A golyóscsapágyas fék megakadályozza az érzékeny élek sérülését.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-festool-mfk700ka.webp',
			'title' => 'MFK 700 KA modul élmaró',
			'desc' => 'A modul élmaró hosszú, fogantyúval ellátott maróasztal-támasztékkal rendelkezik az optimális súlypontelhelyezést biztosítva, illetve biztonságos vezetést tesz lehetővé billenés nélkül. Az 0,1 mm léptékű mélységbeállítás pontos marási eredményeket garantál.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-festool-hkc55.webp',
			'title' => 'HKC 55 kézi billenőbúrás körfűrész',
			'desc' => 'A HKC 55 K teljesítményszabályzó elektronikájának és szénkefe nélküli EC-TEC motorjának tökéletesen összehangolt egysége lehetővé teszi, hogy a legtöbbet hozza ki a 8,0 Ah-s akkumulátorból. Az akkus kézi billenőbúrás körfűrészhez kifejlesztett, 1,6 mm vágásszélességű, keskeny vágóélű fűrészlapokkal együtt maximális teljesítményt érhet el.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-festool-hlc82.webp',
			'title' => 'HLC 82 akkumulátoros gyalugép',
			'desc' => 'Az akkumulátoros gyalugép szénkefe nélküli EC-TEC motorja nagy húzóerőt biztosít, így mindig egyenletesen nagy teljesítményt nyújt, még maximális vágási mélységgel történő gyalulás esetén is. A spirálkés, amely ferdén kap az anyagba, a fát anyag- és szerszámkímélő módon hántolja le. További előny, hogy a spirálkés biztosítja a csökkentett zajterhelést is.',
		),
	),

	/*
	'klimaexpress' => array(
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-klimaexpress-1.webp',
			'title' => 'Balkezes blankoló kés',
			'desc' => 'Speciálisan kialakított Hultafors kés elsősorban villamossági munkát végzők, kifejezetten balkezes munkatársak részére kifejlesztve. 33 mm hosszú és 1,5 mm széles japán karbonacél pengével.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-klimaexpress-2.webp',
			'title' => 'Zajvédelmi fültokok',
			'desc' => '',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-klimaexpress-3.webp',
			'title' => '8 méteres mérőszalag',
			'desc' => 'Extra tartós, könnyen kezelhető kivitel, a ruházathoz csatlakoztatható praktikus füllel.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-klimaexpress-4.webp',
			'title' => 'Sievi magasított talpbetétek',
			'desc' => 'Ha extra gondoskodásra van szüksége a lábaidnak.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-klimaexpress-5.webp',
			'title' => 'Snickers Workwear 1100-as kabát',
			'desc' => 'A legjobb télikabát, amit csak ismerünk',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-klimaexpress-6.webp',
			'title' => 'Carhartt felső',
			'desc' => '',
		),

	),
	'laufen' => array(
		array(
			'title' => 'Jika Pure zuhanyfolyóka',
			'desc' => ['Átgondolt tervezés, egyszerűség és professzionális gyártás', 'S típusú szifon búzzárral', 'textil tömítőmembrán', 'forgatható 360°-os oldalsó kimenettel', '1000mm hosszú, vágható min. 600mm', 'telepítési mélység 60-110mm', 'Ø 50mm 48 l/perc'],
		),
		array(
			'title' => 'Laufen Ineo falba építhető tartály',
			'desc' => ['Bovdenes öblítési mechanizmus', 'Kompakt méretű nyomólapok, különleges design, széles választék', 'Teljes szigetelés', 'Robosztus vázszerkezet (400kg-ig teherbíró)', 'Ajándék „Freshbox” és fali tartó', 'Szerelőbarát felépítés'],
		),

	),
	'leicon' => array(
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-leicon-1.webp',
			'title' => 'iCON iCS50 3D kitűzőeszköz',
			'desc' => ['akár milliméteres mérési és kitűzési pontosság', 'önbeálló szintező', 'vezetéknélküli működtetés lehetősége tablettel vagy dedikált távvezérlővel', 'nagyfelbontású, széleslátószögű kamera', 'automatikus szoftver frissítés', 'IP54 terepállóság'],
		),

	),
	'merkbau' => array(
		array(
			'title' => 'Bautool polisztirol vágó állvánnyal',
			'desc' => ['Max. vágási hosszúság: 1370 mm', 'Max. vágási vastagság: 300 mm', 'Súly: 20 kg', 'fém vázas'],
		),
	),
	'meton' => array(
		array(
			'title' => 'EPS 80 NEXT-CARBON homlokzati hőszigetelő lemez',
			'desc' => 'A NEXT-CARBON 80 hőszigetelő lemez főként homlokzatok hőszigetelésére lett kifejlesztve. A hőszigeteléssel tartós épületszerkezeteket, komfortos, gazdaságosan üzemeltethető épületeket kapunk. A termék homlokzati hőszigetelő bevonatrendszerekben alkalmazott, pihentetett polisztirol keményhab. Szürke színű, grafit adalékolt alapanyagának köszönhetően lényegesen alacsonyabb hővezetési ellenállással rendelkezik, mint fehér változata, ezáltal 20%-kal jobb hőszigetelő tulajdonság érhető el.',
		),
		array(
			'title' => 'NEXT EPS rendszerragasztó',
			'desc' => 'A NEXT EPS rendszerragasztó alkalmas régi és új épületek extrudált (XPS), expandált (EPS) lábazati és expandált (EPS) homlokzati, valamint kifejezetten javasolt grafitos polisztirol alapú hőszigetelő lemezeinek ragasztására, és üvegszövet háló beágyazására, glettelésére kül- és beltérben.',
		),
		array(
			'title' => 'NEXT SILICON Díszvakolat',
			'desc' => 'Felhasználásra kész, vizes hígítású, pasztaszerű díszvakolat, külső és belső igényes falfelületekre, mely környezetbarát, természetes ásványi töltőanyagokat, silicon kötőanyagot és tulajdonságjavító adalékokat tartalmaz. Új és régi homlokzatok dekoratív, időjárás álló bevonataként. Beton vagy hagyományos simító vakolatokra, illetve a MINERAL és a METON EPS homlokzati hőszigetelő rendszer fedővakolatának. Szilikon gyanta tartalma miatt fokozottan védi a felületet az elkoszolódástól.',
		),
		array(
			'title' => 'GROUND SIL Vakolatalapozó',
			'desc' => 'A GROUND SIL felhasználásra kész, silicon bázisú, magas páraáteresztő képességű, környezetbarát, speciális adalékanyagokat tartalmazó, IMAGINE és PASTEL színkártya alapján színre keverhető vakolatalapozó. Simított alapvakolatra, betonfelületre, glettelt falfelületek alapozására alkalmas NEXT SILICON, SILICON PASTEL és MINERAL díszvakolatok alá. Feladata az alapfelület megerősítése, a nedvszívás kiegyenlítése és a tapadó felület biztosítása.',
		),
		array(
			'title' => 'GROUND Univerzális mélyalapozó',
			'desc' => 'A GROUND univerzális mélyalapozó felhasználásra kész, acryl bázisú, környezetbarát, speciális adalékanyagokat tartalmazó, színtelen univerzális mélyalapozó. Javasolt aljzatkiegyenlítők, burkolástechnikai termékek, polisztirol ragasztók, gipszek, glettanyagok, estrichek felhasználása előtti mélyalapozásra. Alkalmas kültéri és beltéri felhasználásra.',
		),
		array(
			'title' => 'AQUA PRO SOLO egykomponensű szálerősített vízszigetelő habarcs',
			'desc' => 'Egykomponensű rugalmas, üvegszál erősítésű, cementkötésű habarcs fürdőszobák, zuhanyzók, erkélyek, teraszok, medencék hidegburkolati rétegrendjében. Épületszerkezetek, ásványi alapfelületek, betonfelületek, előregyártott szerkezetek védelmére és víz elleni szigeteléseként.',
		),
		array(
			'title' => 'X-KONTAKT Tapadóhíd',
			'desc' => 'Az X-KONTAKT tapadóhíd, ásványi anyaggal dúsított, vizes bázisú diszperziós bevonat, tapadásfokozó alapozó. Falak és aljzatok bontás nélküli újra burkolást megelőző előkészítésre, tapadás fokozására, valamint az egyenletes nedvszívóképesség beállítására. A tapadóhíddal ellátott felületre az új burkolat a szokásos ragasztókkal könnyen felvihető, tehát nem szükséges a régi burkolatot elbontani. Felhasználható kül- és beltérben aljzat kiegyenlítés előtti, vakolási, alapozási és hideg burkolási munkálatok előtt, vagy OSB lemezre, öntött betonra, estrichre felhordva is alkalmazható a jó alapfelület létrehozásához. Minden olyan alapfelületnél, amelynél szükséges az erősen tapadó érdesség, nedvszívó és nem nedvszívó felületekre egyaránt.',
		),
		array(
			'title' => 'AQUA PRO SEAL folyékony fólia',
			'desc' => 'Egykomponensű, vizes bázisú felhasználásra kész, vízzáró, rugalmas, repedésáthidaló képességgel bíró folyékony fólia, amely környezetbarát, oldószermentes, természetes ásványi töltőanyagokat, acryl kötőanyagot és tulajdonságjavító adalékokat tartalmaz. Az AQUA PRO SEAL folyékony fólia a burkolati rétegrendben üzemi és csapadékvíz elleni vízszigetelő rétegként alkalmazható, hidegburkolatok alá, kültérben és beltérben, oldalfalakon és aljzatokon.',
		),
		array(
			'title' => 'AQUA PRO FLEX kenhető vízszigetelés',
			'desc' => 'Egykomponensű, vizes bázisú felhasználásra kész, vízzáró, rugalmas, repedésáthidaló képességgel rendelkező kenhető szigetelés, amely környezetbarát, oldószermentes, természetes ásványi töltőanyagokat, acryl kötőanyagot és tulajdonságjavító adalékokat tartalmaz. Az AQUA PRO FLEX kenhető vízszigetelés a burkolati rétegrendben üzemi és csapadékvíz elleni vízszigetelő rétegként alkalmazható, hidegburkolatok alá, kültérben és beltérben, oldalfalakon és aljzatokon, valamint gipszkarton szerkezeten. Vízzáró felületet képez, megvédi a burkolat alatti nedvességre érzékeny alapfelületet.',
		),
		array(
			'title' => 'AQUA PRO LINE szilikontartalmú, flexibilis, vízlepergető fugázóanyag (CG2 WA)',
			'desc' => 'Flexibilis, vízlepergető, különösen képlékeny, szilikon tartalmú, nagy kopásállóságú, nagy szilárdságú, színtartó, jól tűri a nagy hőingadozást, gombásodás gátló hatással. A fugázó anyag alacsony vízfelvételű, padlófűtés és falfűtés rendszerekre is ajánlott, könnyen tisztítható. Alkalmas padlófűtésekre helyezett hidegburkolatok és nagy igénybevételnek kitett felületek fugázásához bel- és kültérben. Csempe-, gránit-, márvány-, műkő-, gres-, kerámialapok fuga hézagjainak kitöltésére 2–7 mm-ig. Saválló fugázásra és dilatációs hézagok kitöltésére, illetve nagy vízterhelésnek kitett helyeken (ipari környezetben, autómosókban stb.) nem alkalmazható. Kapható 40 színben!',
		),
		array(
			'title' => 'WASSER DUO kétkomponensű kenhető vízszigetelés',
			'desc' => 'Kétkomponensű, vizes bázisú felhasználásra kész, szálerősített, vízzáró, nagy rugalmasságú, repedésáthidaló képességgel bíró kenhető, glettelhető vízszigetelés, amely környezetbarát, természetes ásványi töltőanyagokat, acryl kötőanyagot és tulajdonságjavító adalékokat tartalmaz. Kül – és beltéri felhasználásra, fürdőszobák, zuhanyzók, erkélyek, teraszok, medencék hidegburkolati rétegrendjében. Épületszerkezetek, ásványi alapfelületek, betonfelületek védelmére és víz elleni szigeteléseként. A WASSER DUO alkalmazható negatív -és pozitív víznyomás elleni védelem esetén is. Repedésáthidaló, rugalmasan eltömíti, illetve áthidalja a meglévő és később keletkező repedéseket maximum 5mm-ig. Vízzáró felületet képez, megvédi a burkolat alatti nedvességre érzékeny alapfelületet. Nedves, nem kellően száraz alapfelületen a WASSER DUO nem használható!',
		),
		array(
			'title' => 'ESTRICH 30 fagyálló estrich beton',
			'desc' => 'Gyárilag előkevert, por alakú, cement kötőanyagot, ásványi töltőanyagot és tulajdonságjavító adalékokat tartalmazó, felhasználásra kész fagyálló cementestrich. Beltéri használatra, padlófűtés esetén is, valamint kültérben megfelelő burkolattal ellátva. Önálló aljzatok készítésére alkalmas úsztatott estrichként, vagy az alapfelülettel közvetlenül érintkező kontakt estrichként.',
		),
		array(
			'title' => 'X-FLOOR 3-30 mm, önterülő aljzatkiegyenlítő',
			'desc' => 'Gyárilag előkevert, por alakú, cement és műgyantakötésű, flexibilis, önterülő aljzatkiegyenlítő szárazhabarcs. Bel- és kültéri stabil betonaljzatok, hőingadozásnak kitett felületek, padlófűtéses helyiségek aljzatbetonjának megbízható, repedésmentes kiegyenlítésére, ragasztott padlóburkolatok alá. 3-30 mm rétegvastagság kiegyenlítésére egy rétegben.',
		),
		array(
			'title' => 'STONE PRO S1 flexibilis burkolatragasztó (C2TE S1)',
			'desc' => 'STONE PRO S1 gyárilag előkevert, por alakú, cement kötőanyagot, ásványi töltőanyagot, szálerősítést és tulajdonságjavító adalékokat tartalmazó fagyálló szürke és fehér színben is elérhető flexibilis ragasztóhabarcs. Különösen alkalmas homlokzati burkolatok, valamint nagyméretű, sötét színű burkolólapok ragasztására, nagy mechanikai, termodinamikai terhelésnek kitett felületekre (kent szigetelésekre, teraszokra, erkélyekre, fűtött alapfelületekre). Alkalmas meglévő burkolatra, csempét csempére történő ragasztásra. Kerámia csempék, mozaikok, természetes és műkövek, greslapok, finomkőlapok szokásos építőipari alapfelületekre történő ragasztására, bel – és kültérben egyaránt. Max. 10000 cm2 lapméretig (pl: 100×100cm).',
		),
	),*/
	'tesa' => array(

		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-tesa-74922.webp',
			'title' => 'tesa® 74922 - Öntapadó védőpapír  ',
			'desc' => 'Robusztus papír védelem

<strong>Alkalmazás</strong>
- Felületek védelme felújítási munkák során: padlók, lépcsők ablakpárkányok 
- Ideális különböző felületeken: PVC, ablakok és alumínium - NEM használható természetes kőre!
- Padlók és nagy forgalmú területek védelme felújításkor

<strong>Jellemzők</strong>
- Robusztus: 100%-ban újrahasznosított szálból készült hátlap, FSC® tanúsítvánnyal rendelkező papír (130 µm)
- Nagyon stabil: 100%-os ragasztófedés
- Tökéletesen áthelyezhető egy hónapig
- Könnyen, nyom nélkül eltávolítható: beltérben 3 hónapig
 [<a href="https://www.tesa.com/hu-hu/mesteremberek/tesa-74922-oentapado-vedopapir.html?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018" target="_blank">További információ &rarr;</a>]
',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-tesa-74921.webp',
			'title' => 'tesa® 74921 - Öntapadó védőfólia ',
			'desc' => 'Kiváló minőségű, nagy felületű védőfólia

<strong>Alkalmazás</strong>
- Védelem különböző felületeken: üveg, PVC, PC, alumínium
- Bútorvédelem: megakadályozza a karcolásokat és foltokat a szállítás és tárolás során

<strong>Jellemzők</strong>
- Erős UV-állóság: megfelel az EU szabványnak: ISO 4892-2-A
- Stretch fólia: kezdeti hosszának 200%-áig nyújtható 
- Ideális hosszú távú építkezésekhez: akár 6 hónapig nyom nélkül eltávolítható kültéri üvegen, alumíniumon és PVC-n (szakadás nélkül)
- Kék színű: kiváló láthatóságot biztosít a precíz védelem érdekében
 [<a href="https://www.tesa.com/hu-hu/mesteremberek/tesa-74921-oentapado-vedofolia-ueveghez.html?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018" target="_blank">További információ &rarr;</a>]
',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-tesa-04460.webp',
			'title' => 'tesa® 04460 - 2az1-ben Precíziós festőszalag',
			'desc' => 'Hatékony és időtakarékos maszkolási eljárás – a kiváló festési eredményekért!

<strong>Alkalmazás</strong>
Két réteg prémium precíziós szalag egy tekercsen
2 alkalmazáshoz egy helyen pl. tömítés dekorátor tömítéssel vagy tömítőanyaggal, majd festékréteggel

<strong>Jellemzők</strong>
- Két réteg prémium tesa® Precíziós Festőszalag egy tekercsen
- A tesa® „Washi” 4440 UV álló Precíziós Festőszalag az alsó réteg, a legjobb festési eredményért bel- és kültéren
- UV-állóság akár 6 hónapig: maradványmentes eltávolítás
- Nincs elszíneződés a felületeken, mint például a fehér PVC ablakkereteken
- tesa® „Washi” 4344 Színelválasztó Festőszalag, a felső réteg
- Vékony, de robusztus papír hátlap a precíz festési élekért
- A felső réteg egyszerű eltávolítása az 1 mm-es papír eltolásnak köszönhetően
 [<a href="https://www.tesa.com/hu-hu/mesteremberek/tesa-professional-4460-2in1-precision-mask-szalag.html?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018" target="_blank">További információ &rarr;</a>]
',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-tesa-4451.webp',
			'title' => 'tesa® Easy Cover Spray takaró papír 
		',
			'desc' => 'A tesa® Easy Cover Spray 4451 biztonságos és megbízható megoldás festékkel és lakkal végzett szórásos festési munkákhoz, például ajtókeretek vagy szegélylécek festése során. A tesa Easy Cover 4451 mindkét szélét Washi maszkolószalaggal láttuk el a könnyű felvitel és a borotvaéles festék élek eléréséhez. Ez a termék a korlátok, balusztrádok, ablakpárkányok, ajtókeretek vagy szegélylécek védelmére is használható.
		•	Ideális ajtókeretek vagy szegélylécek festésére
		•	Korlát, balusztrád, ablakpárkány vagy szegélyléc gyors maszkolásához
		•	Még könnyebben használható a festőhenger markolatának segítségével
		A termék jellemzői
		•	Dupla ragasztószalag a hatékony és biztonságos maszkolás érdekében
		•	Maradékmentes eltávolítás akár 3 hónapig beltéren és 4 hétig kültéren
		•	Méret: 25m x 20 cm 
		[<a href="https://www.tesa.com/hu-hu/mesteremberek/tesa-professional-4451-easy-cover-precision-standard-spray-painting.html?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018" target="_blank">További információ &rarr;</a>]

		',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-tesa-74613.webp',
			'title' => 'tesa® PRO 74613 Duct Tape',
			'desc' => 'A tesa PRO 74613 Duct Tape minden munkában támogatja Önt: Vízlepergető, könnyen felhordható és tartós, ez a ragasztószalag bármilyen felületen használható. Rendkívül rugalmas és erősebb, mint valaha. Az Ön új gyors, megbízható megoldása szinte bármilyen javításhoz!
			A tesa PRO Duct Tape bármilyen felhasználásra készen áll, akár beltéren, akár kültéren.
			Vízlepergető, és durva felületeken is működik. Ez a szalag minden szakember igényeit kielégíti: könnyen szakítható és hosszú élettartamú, könnyen letekerhető, és rugalmasan alkalmazkodik bármilyen alapfelülethez, így biztosítva az optimális tömítést.
			Ez az univerzális ragasztószalag erős tapadószilárdságával ideális ideiglenes és állandó alkalmazásokhoz, javításhoz, jelöléshez, rögzítéshez, lezáráshoz és csomagoláshoz. [<a href="https://www.tesa.com/hu-hu/mesteremberek/tesa-pro-74613-duct-tape.html?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018" target="_blank">További információ &rarr;</a>]
			',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-tesa-mounting-pro.webp',
			'title' => 'Mounting for PRO szerelőszalagok',
			'desc' => 'Professzionális ragasztószalagok a megbízható, gyors és tiszta, fúrás nélküli rögzítéshez. Használja ki a tesa szakértelmét a kétoldalas szalagok terén, amelyeket kihívást jelentő iparágakban, autóiparban, repülőgépiparban és építőiparban használnak. Tapasztalja meg az új tesa® PRO Craftsmen választékot az összetett szerelési és ragasztási alkalmazásokhoz. 
			Megbízható szerelő- és ragasztószalagok minden alkalmazáshoz
			- Nincs szükség fúrásra – Szerelőszalagok olyan felületekre is, ahol a lyukak nem elfogadhatóak
			- Egyszerű és gyors használat – hatékony szerelőszalagjaink tökéletesek arra, hogy időt takarítson meg
			- Beltéri vagy kültéri – különböző változatok állnak rendelkezésre, amelyek minden igényt kielégítenek

			Még soha nem volt ilyen gyors a tárgyak rögzítése – nincs szükség fúrásra vagy szögekre. Nincs por, nincs zaj, nincs gond! [<a href="https://www.tesa.com/hu-hu/mesteremberek/tesa-pro-szereloszalagok?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018" target="_blank">További információ &rarr;</a>]
			',


		),
	),
	'xella' => array(
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-xella-ytong.webp',
			'title' => 'Ytong lépcső',
			'desc' => 'Rengeteg kreatív lehetőség, különböző formavilág. Az Ytong előregyártott lépcsőelemekkel történő építkezés alatt, az adott projekthez igazadó méretre gyártott kész elemek jelentősen lerövidítik a kivitelezés idejét, továbbá csökkentik a szükséges szakmunkások mennyiségét.<br>Előnye:',
			'feats' => ['azonnali terhelhetőség', 'könnyű és gyors beépíthetőség, nem igényel zsaluzást és ideglenes alátámasztást', 'helyszíni adottságokhoz igazodó megoldás', 'a falazással egy időben vagy utólag is beépíthető', 'költséghatékony szerkezet', 'minimális nedvesség bevitel a kivitelezés során', 'biztonságos, kiváló tűzállóság '],
			'more' => ['title' => 'Bővebben', 'href' => 'https://www.xella.hu/hu_HU/Lepcso']
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-xella-multipor.webp',
			'title' => 'Multipor ásványi hőszigetelés',
			'desc' => 'A Multipor egy stabil, ásványi kristályszerkezetű hőszigetelő lap, mely új alternatívát nyújt a hagyományos, szálas vagy műanyaghab szigetelésekkel szemben. Lúgos kémhatása alapvetően megakadályozza a gombák és penészspórák elszaporodását. Gyártásuk környezettudatos technológiával, ásványi alapanyagok (homok, mész, víz) felhasználásával történik.<br>Előnyei:',
			'feats' => ['kiváló hőszigetelő képesség', 'nem éghető (A1 tűzvédelmi besorolás)', 'jó páraáteresztő ', 'széleskörű felhasználás (külső-, belső oldal, alulról hűlő födém)', 'könnyen méretre vágható, alakítható', 'masszív, homogén szerkezet', 'hangelnyelő, alkalmazásával nem rontja a fal akusztikai teljesítményét', 'impregnált, víztaszító', 'ellenáll a kártevőknek (bogarak, rágcsálók)'],
			'more' => ['title' => 'Bővebben', 'href' => 'https://www.multipor.hu/hu_HU/']
		),
	),
	/*
	'ravak' => array(
		array(
			'title' => 'Freedom Corner fürdőkád',
			'desc' => 'Akril sarokkád, mely egyesíti a térben álló és az aszimmetrikus kád előnyeit. Kialakítását sarokba való beépítésre tervezték, így érdekes önálló sarokkád-változatot alkot.',
		),
		array(
			'title' => 'Espirit csaptelepek',
			'desc' => 'Az Espirit csaptelepeket Black Matt, Graphite Brushed, Rose Gold Brushed, Chrome, White Velvet színkivitelben szállítjuk. A BeCool funkcióval rendelkező csaptelep csökkenti a melegvíz-fogyasztást, ezáltal pedig energiát takarít meg.',
		),
		array(
			'title' => 'Eleganta csaptelepek',
			'desc' => 'Az Eleganta csaptelepeket Chrome, White Velvet, Black Matt, Graphite Brushed, Rose Gold Brushed színkivitelben szállítjuk. A BeCool funkcióval rendelkező csaptelep csökkenti a melegvíz-fogyasztást, ezáltal pedig energiát takarít meg.',
		),
		array(
			'title' => 'Ceramic Slim Shelf O kerámiamosdó',
			'desc' => 'A mosdót úgy tervezték, hogy pultra vagy szekrényre helyezhető legyen. A csaptelep területén, amely általában nedves, kialakítottak egy tárolóhelyet például a szappan számára. Minden más a mosdó melletti pultra helyezhető.',
		),
		array(
			'title' => 'Ceramic Slim Wall O kerámiamosdó',
			'desc' => 'A mosdót úgy tervezték, hogy pultra vagy szekrényre helyezhető legyen. A csaptelep területén, amely általában nedves, kialakítottak egy tárolóhelyet például a szappan számára. Minden más a mosdó melletti pultra helyezhető.',
		),
		array(
			'title' => 'Freedom Ypsilon fürdőkád',
			'desc' => 'Tervezők által válogatott színekben a RAVAK új Freedom és Ypsilon kádjai. ',
		),
	),
	'rockwool' => array(
		array(
			'title' => 'Frontrock Super',
			'desc' => 'A FRONTROCK SUPER lemezek különösen alkalmasak épületek homlokzatának neméghető, páraáteresztő hő- és hangszigetelésére, homlokzati tűzterjedési gátak kialakítására. Tűzvédelmi szempontból bármely magasságú és kockázati osztály besorolású épületnél korlátozás nélkül beépíthető. A FRONTROCK SUPER rögzítése részleges felületű felragasztás és dübelezés egyidejű alkalmazásával történik.',
		),
		array(
			'title' => 'Airrock LD Super',
			'desc' => 'Az AIRROCK LD SUPER (LD = Low Density, kis testsűrűség) lemezek elsősorban a magastetők szarufák közötti – DELTAROCK lemezekkel készült – hőszigetelésének szarufák alatti kiegészítő hőszigeteléseként, illetve nem járható padlásfödémek, zárófödémek hőszigeteléséhez ajánlható. Különösen kedvező az alkalmazása magasabb akusztikai, tűzvédelmi követelményeket kielégítő szerelt gipszkarton válaszfalak betéteként. Javasolt a használata olyan szerkezetekben, ahol a kőzetgyapot áramló levegővel közvetlenül érintkezik.',
		),
		array(
			'title' => 'Deltarock',
			'desc' => 'A DELTAROCK éklemezek különösen alkalmasak a magastetők szarufák közötti hőszigeteléséhez. Az éklemezek sarkainak levágásával bármilyen 50 és 100 cm közötti szarufaköz-távolság gazdaságosan kitölthető. Rögzítést nem igényel. Célszerű felette szélzáró, páraáteresztő tetőfólia alkalmazása a teljes szarufamagasság szigetelőanyaggal történő kitöltése mellett, ügyelve a belső oldali felületfolytonos párazáró réteg kialakítására.',
		),
	),
	'sika' => array(
		array(
			'title' => 'Sika termékújdonság – SikaWall-550 Magic',
			'desc' => 'A SikaWall-550 Magic egy dekoratív beltéri felület képző anyag, mely dizájn és látszóbeton falfelületek kialakításához alkalmazható. A Sika standján megtalálható lesz egy bemutató fal is, melyen megcsodálható lesz ez a vékonyrétegű, elegáns, modern megjelenést kölcsönző különleges felület.',
		),
	),
	'soudal' => array(
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-soudal-1.webp',
			'title' => 'T-Rex Hybrid polimer szerelő ragasztó',
			'desc' => 'Rendkívül nagy teherbírású, nagyon erős ragasztó NAGYON NAGY kezdeti tartóerővel. Az SMX polimer technológián alapuló Xtreme Power hihetetlen kötőerőt és alapozó nélküli tapadást biztosít a legtöbb építőanyagon, ideértve a vizes és nedves felületeket is.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-soudal-2.webp',
			'title' => 'Soudal Multi Spray kenőanyag',
			'desc' => 'Magas minőségű, univerzálisan alkalmazható spray 8-féle hatással: használhatórozsdaoldóként és eltávolítóként, rozsda elleni védelemként, zsírzóként, olajozóként,tisztítóként. Víztaszító hatású, és kontakt sprayként is működik. A tisztítás után védőfilmbevonatot képez. A fémeket és műanyagokat nem támadja meg. A gumi anyagúalkatrészek élettartamát meghosszabbítja.',
		),
	),
	'sortimo' => array(
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-sortimo-1.webp',
			'title' => 'SR5 járműberendezés',
			'desc' => 'A Sortimo ötödik generációs állványrendszere, mely a repülőgépiparban is használt, extra könnyű ötvözetekből készül.  Innovatív megoldásaival maximálisan személyre szabott rendszert kínál minden iparág szakembereinek.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-sortimo-2.webp',
			'title' => 'Globelyst 4 állványrendszer',
			'desc' => 'A jól bevált járműberendezés, mely tökéletesen ötvözi a klasszikus állványrendszerek robusztus felépítését és a modern berendezések rugalmasságát. Tartozékok és kiegészítők széles választéka segítségével minden szakma elvárásának megfelel.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-sortimo-3.webp',
			'title' => 'ProClick',
			'desc' => 'A ProClick szerszámövön egyetlen mozdulattal cserélhető szerszámtáskák megkönnyítik a mobil munkavégzést, miközben jelentősen meggyorsítják a szerszámok elő- és összekészítését.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-sortimo-4.webp',
			'title' => 'WorkMo',
			'desc' => 'A WorkMo modularitásának köszönhetően egyénileg összeállítható, így minden helyzetben alkalmazható: mobil munkapad, műhelykocsi, műhelypolc és mobil munkaállomás egyben.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-sortimo-5.webp',
			'title' => 'Jumbo Unit',
			'desc' => 'A nagy teherbírású XL-es fiókok hatalmas segítséget nyújtanak a hosszú, vagy nehéz áruk, felszerelések tárolásánál, rakodásával akár a hátsó, akár az oldalsó ajtón keresztük.',
		),
	),
	'trilak' => array(
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-trilak-1.webp',
			'title' => 'Új Héra Beltéri Falfesték',
			'desc' => 'A tökéletesen fehér felületet képző Héra Beltéri falfesték egyedi összetétele lehetővé teszi, hogy poliamid festőhengerrel történtő felhordásakor a legoptimálisabb festékmennyiség kerüljön a falakra. A hozzáadott oldószert nem tartalmazó, szagmentes és könnyen hengerelhető festék két rétegben kiváló fedést biztosít, továbbá pára- és légáteresztő felületet képez. Héra Színezőpasztákkal bármilyen pasztellárnyalatra egyszerűen színezhető.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-trilak-2.webp',
			'title' => 'Trinát Aqua uniTOP alapozó és fedőfesték',
			'desc' => 'Vízzel hígítható, selyemfényű, akrilgyanta kötőanyagú alapozó és fedőfesték fa, műanyag és fém felületekre, gyermekjátékokra is. Száradása gyors, nem jár kellemetlen oldószerszaggal. Esztétikus, egyenletes és tartós bevonatot biztosít szélsőséges időjárásnak kitett felületeken is. Az elérhető RAL színeken kívül több ezer színben keverhető.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-trilak-3.webp',
			'title' => 'Trinát multiTOP 9in1 alapozó és fedőfesték',
			'desc' => 'A Trinát Special multiTOP 9in1 egyedi formulájának köszönhetően egy rendkívül sokoldalúan felhasználható vizes bázisú alapozó és fedőfesték egyben. Legyen szó akár beltéri vagy kültéri festésről, rengeteg különböző felületen könnyedén megtapad és hosszútávú védelmet biztosít.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-trilak-4.webp',
			'title' => 'Héra MY color beltéri falfesték',
			'desc' => 'Kiváló minőségű, tartós matt festék beltéri falfelületek festésére. A Héra MyColor beltéri matt falfesték kiváló fedőképességű, mosható, pára- és legáteresztő bevonatot képez, színei pedig élénkek és tartósak. Egyszerű használatának és illatosított formulájának köszönhetően széles körben alkalmazható.',
		),
	),
	'polymatrix' => array(
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-polymatrix-1.webp',
			'title' => 'Neoproof Polyurea R 2 komponensű rugalmas vízszigetelő bevonat',
			'desc' => 'Kétkomponensű, hengerrel vagy Airless szórással felhordható elasztomer poliaszphartikus poliurea, kiváló korai esőállósággal, ideális különféle felületek hosszú távú védelmére. Hólyagmentes és nedvesség át nem eresztő filmet képez, amely magasan ellenáll az UV sugárzásnak és a mechanikai igénybevételnek. Alkalmas tetők vízszigetelésére.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-polymatrix-2.webp',
			'title' => 'Neodur FT Elastic Gyorskötésű rugalmas padló rendszer',
			'desc' => 'Gyors kötésű, hengerelhető rugalmas alifás poliurea rendszer, amely alkalmas padlók védelmére, ahol kiemelkedő vízszigetelő tulajdonságok, valamint nagy kopásállóság és mechanikai igénybevétel szükséges. Magas UV állóság.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-polymatrix-3.webp',
			'title' => 'Neodur Fast Track Gyors kötésű, poliurea rendszer padlóburkolatokhoz',
			'desc' => 'Innovatív, gyorsan kötő, nagy szilárdságú, hengerrel felhordható, kétkomponensű alifás poliurea rendszer kül- és beltéri padlóburkolatokhoz (UV álló). Gyorsan szárad és kikeményedik, lehetővé téve a padlórendszer teljes felhordását egy napon belül ( 1 réteg alapozó és 2 réteg bevonat), és az elkészítést követően már másnap (teljes forgalom) terhelhető.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-polymatrix-4.webp',
			'title' => 'Neodur FT Clear Átlátszó, gyorsan száradó, poliurea teraszbevonat',
			'desc' => 'Átlátszó, gyorsan száradó, hengerrel, ecsettel felhordható rugalmas alifás (UV álló) poliurea lakk, ideális tetők és erkélyek vízszigetelésére és védelmére, amelyek burkolólapokkal fedettek.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-polymatrix-5.webp',
			'title' => 'Neoproof PU W-40 Vízbázisú alifás poliuretán vízszigetelő bevonat',
			'desc' => 'Vízbázisú poliuretán elasztomer vízszigetelő bevonat tetőkre, amikor mechanikai tartósságra és kiemelkedő vízszigetelő tulajdonságokra van szükség. Nedvességálló filmet képez, amely ellenáll az UV-sugárzásnak, a mechanikai igénybevételnek és a rendkívül alacsony hőmérsékletnek, akár -40°C-ig.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-polymatrix-6.webp',
			'title' => 'Silimper Nano - vízbázisú nano-molekuláris vízlepergető impregnáló vegyület',
			'desc' => 'Szilán-sziloxán, egykomponensű, vízbázisú nano-molekuláris impregnáló vegyület, nagy áthatoló képességgel és hidrofób teljesítménnyel, ideális kül- és beltéri építési felületeken víz-lepergetőként.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-polymatrix-7.webp',
			'title' => 'Neotextil NP szalag vagy háló - Nem szőtt poliészter erősítő háló',
			'desc' => 'Nem szőtt poliészter szövet háló 100gr/m 2 tömegű, alkalmas hengerelhető vízszigetelő bevonatok megerősítésére. Elérhető 0,98x100m-es tekercsben vagy 14cmx10m-es szalagban.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-polymatrix-8.webp',
			'title' => 'Revinex Többcélú kopolimer alapozó és adalék anyag',
			'desc' => 'Többcélú kopolimer emulzió és alapozó, amelyet a cementhabarcsok és bevonatok tulajdonságainak javítására terveztek. Figyelemre méltó vízállóságot, rugalmasságot és tapadást biztosít az építési és javítási alkalmazások széles skálájában (pl. cementesztrichek és habarcsok, cement alapú bevonatok, fugahabarcsok, vakolatok, csemperagasztók, stb.)',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-polymatrix-9.webp',
			'title' => 'Epoxol CM - Háromkomponensű, önterülő epoxi-cement rendszer padlóburkolatokhoz',
			'desc' => 'Háromkomponensű, epoxi-cement alapú rendszer, alkalmas 1-3mm vastagságú önterülő padlóbevonatok készítésére. CT-C30-F7-A3-B2,0 esztrichanyagként besorolva az ΕΝ 13813 szerint.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-polymatrix-10.webp',
			'title' => 'Epoxol Putty - Tixotróp, kétkomponensű ragasztó-tömítő és javító rendszer',
			'desc' => 'Tixotróp, kétkomponensű, oldószermentes epoxi rendszer, javítási, tömítési, rögzítési és ragasztási alkalmazásokhoz, magas mechanikai és vegyi ellenálló képességgel. Magas viszkozitású, így nagy hézagokat fed le folyás nélkül.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-polymatrix-11.webp',
			'title' => 'Neodur Poliurea - Átlátszó alifás poliurea, kültéri kőszőnyeg rendszer',
			'desc' => 'Kétkomponensű, átlátszó alifás polikarbamid rendszer, ideális kültéri dekoratív kőszőnyegek készítéséhez kvarchomok, granulátumok, stb. hozzáadásával. Magas mechanikai ellenállást és hosszú távú UV-állóságot biztosít, sárgulás nélkül',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-polymatrix-12.webp',
			'title' => 'Neodur Varnish Lakk – Átlátszó kétkomponensű poliuretán fényes lakk UV szűrőkkel',
			'desc' => 'Átlátszó, kétkomponensű, oldószeres poliuretán fényes lakk UV szűrőkkel, alifás poliizocianátokkal térhálósítva, alkalmas mikrocement bevonatok és különféle egyéb építési felületek védelmére és díszítésére. Úszómedencékben védőlakkként is alkalmazható.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-polymatrix-13.webp',
			'title' => 'Neotex PU Joint - Nagy rugalmasságú tömítőanyag',
			'desc' => 'Egykomponensű poliuretán elasztomer tömítőanyag, kiváló tapadóképességgel különböző építési felületeken.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-polymatrix-14.webp',
			'title' => 'MASTER PUR SC-30 PURHAB szigetelő',
			'desc' => '30 kg/m3 sűrűségű, zárt cellás kétkomponensű szórt poliuretán habrendszer tetők, falak, födémek, agrárépületek stb. hőhídmentes hőszigeteléséhez. A rendszer kiemelkedő hőszigetelő képességgel és kiváló tapadással rendelkezik a legtöbb építőipari felülethez.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-polymatrix-14.webp',
			'title' => 'MASTER PUR SC-08 PURHAB szigetelő',
			'desc' => '8 kg/m3 sűrűségű, nyitott cellás kétkomponensű szórt poliuretán habrendszer hőhídmentes hőszigeteléshez. A rendszer jó hőszigetelő képességgel és kiváló tapadással rendelkezik a legtöbb építőipari felülethez.',
		),
	),*/

);

$ujdonsagok_en = array(
	'dufa' => array(
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-dufa-1.webp',
			'title' => 'Dufa Diamond',
			'desc' => '<h1>The <strong>düfa Diamond</strong> has arrived!</h1>
<p><em>A wall paint without compromise for the Perfect Home.</em></p>
<p><strong>düfa Diamond</strong> is a high-quality, pollutant-free, environmentally friendly wall paint that features outstanding properties thanks to the latest technological developments.</p>
<ul>
  <li><strong>High whiteness</strong> – clean, radiant surfaces, aesthetic appearance, even with a single coat</li>
  <li><strong>Free from harmful substances</strong> – VOC-free, environmentally and health-friendly formula</li>
  <li><strong>Brilliant whiteness, excellent coverage and durability</strong> – long-lasting protection, elegant finish</li>
  <li><strong>Easy to apply</strong> – fast drying, excellent coverage and adhesion</li>
  <li><strong>Excellent vapor permeability</strong>, yet <strong>washable surface</strong></li>
  <li><strong>No odor</strong> during painting – ideal for children rooms</li>
  <li><strong>Perfect choice</strong> for both residential and professional use</li>
</ul>
<p>This exceptionally durable interior wall paint is specifically designed for those who demand high standards in the aesthetics and resistance of interior wall surfaces.</p>
<p><strong>düfa Diamond</strong> is an ideal choice for homes, offices, public institutions, and any space where <strong>cleanliness</strong>, <strong>safety</strong>, and <strong>aesthetics</strong> are of utmost importance.</p>
<p><a href="https://www.düfa.hu" target="_blank" rel="noopener noreferrer">More information: Düfa Diamond – Premium quality interior wall paint – Düfa paints</a></p>
'
		),
	),
	
	'blum' => array(
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-18.webp',
			'title' => 'MINIPRESS Top with EASYSTICK',
			'desc' => '<strong>MINIPRESS Top + EASYSTICK – Digital precision made simple</strong>The MINIPRESS Top is a versatile and accurate drilling machine, capable of both vertical and horizontal drilling. The EASYSTICK digital stop system automatically calculates and sets drilling points based on component dimensions—so you can work quickly and precisely without templates, measurements, or manual calculations. The system is also compatible with DYNALOG software, ensuring seamless planning and execution.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-17.webp',
			'title' => 'MINIPRESS P',
			'desc' => '<strong>BLUM MINIPRESS P – Maximum efficiency without templates</strong>The MINIPRESS P provides a stable and precise solution for installing fittings. Quick tool changes, a nine-spindle drilling head, and adjustable distances enable accurate drilling without templates. Ideal for intensive use and user‑friendly operation.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-15.webp',
			'title' => 'ECODRILL',
			'desc' => '<strong>BLUM ECODRILL – Precise hinge holes quickly and easily</strong>ECODRILL is a handheld compact drilling template enabling three accurate holes for lift hinges simultaneously. Easy to use, ideal for on‑site installations or small workshops.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-4.webp',
			'title' => 'BOXFIX E‑M',
			'desc' => '<strong>BLUM BOXFIX E‑M – Professional drawer assembly</strong>This semi‑automatic BOXFIX E‑M simplifies precise assembly of MERIVOBOX drawers. Pneumatic operation and adjustment elements enable fast and uniform quality work, suitable for both custom and mass production.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-12.webp',
			'title' => 'Universal Pin‑type Template',
			'desc' => '<strong>BLUM Universal Pin‑type Template – Precision without machinery</strong>A versatile manual template to facilitate precise installation of BLUM fittings—such as hinges, mounting plates, drawer and front runners. Compact and adjustable design makes it ideal for smaller workshops or on‑site assembly.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-13.webp',
			'title' => 'Universal Straight Pin‑type Template',
			'desc' => '<strong>BLUM Universal Straight Pin‑type Template – Accurate drilling anywhere</strong>This versatile manual template is ideal for quickly and precisely drilling corpus sides, load‑bearing panels, mounting plates, and adapters—whether working on panels or assembled furniture. The depth scale supports various fittings, whether overlay or inset. Robust yet lightweight construction ensures long‑term comfort and precision—simple, reliable, universal.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-14.webp',
			'title' => 'Universal Drilling Template',
			'desc' => '<strong>BLUM Universal Drilling Template – Precise work anywhere</strong>A versatile template for pre‑drilling front fasteners, railings, drawer backs, bottom panels, and AVENTOS components. Built‑in scale enables quick adjustment, and its sturdy design ensures accurate and reliable results.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-3.webp',
			'title' => 'Pin‑type Template for Lift‑Hinge Systems',
			'desc' => '<strong>BLUM Pin‑type Template – Simple and precise marking</strong>This template enables fast and accurate transfer of mounting points for lift hinges and mounting plates—usable on cabinet bodies or doors. Its adjustable stop and scale deliver precise settings for various overlay types, speeding up work and eliminating time‑consuming measurements.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-10.webp',
			'title' => 'Mounting‑plate Marking Template',
			'desc' => '<strong>BLUM Mounting‑plate Marking Template – Accurate marking quickly</strong>A compact template providing precise pre‑drilling for mounting plates and adapter panels. Suitable for both series and custom furniture. Easy to use with marking-based operation; multiple templates can be used at once for increased efficiency. Made of durable steel for long‑lasting reliability in any workshop.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-5.webp',
			'title' => 'Cross‑shaped Drilling Template for Mounting Plates',
			'desc' => '<strong>BLUM Cross‑shaped Mounting‑plate Template – Precise fastening made easy</strong>This template is ideal for accurate drilling of cross-shaped mounting plates and adapter panels (BLUMOTION, TIP‑ON), whether in custom or series work. With integrated pin for 32 mm system drilling, it enables fast, accurate work without measuring. Lightweight yet robust plastic/steel design ensures reliable on-site and workshop use.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-9.webp',
			'title' => 'Drilling Template for BLUMOTION / TIP‑ON Installation',
			'desc' => '<strong>BLUM Template for BLUMOTION Unit – Flawless drilling every time</strong>This indispensable template allows precise front‑side drilling of BLUMOTION fastening points on door fronts or lift hinge sides. Ideal for AVENTOS HK top series, CLIP top hinges, and TIP‑ON mechanisms. Marking-based operation ensures flawless hole placement; durable plastic/steel construction guarantees long‑term reliability in workshop and on-site environments.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-8.webp',
			'title' => 'Corpus Angle‑measuring Template',
			'desc' => '<strong>BLUM Corpus Angle‑measuring Template – Exact angles for seamless fit</strong>This lightweight plastic template enables quick angle measurement on cabinet bodies, simplifying proper lift‑hinge selection—especially useful in cases of non‑standard or custom furniture. Comfortable to use both in workshops and on-site, ensuring precise assembly and durability.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-11.webp',
			'title' => 'Multi‑Function Template for Lift‑Hinges',
			'desc' => '<strong>BLUM Multi‑Function Template – Precision solution for all fastening needs</strong>This versatile template allows simultaneous pre‑drilling of side holes (Ø 8 or Ø 2.5 mm), straight and cross mounting plates, and adapter panels (for BLUMOTION | TIP‑ON doors). Its marking-based workflow ensures perfect, error‑free drilling and accelerates process. Made of durable plastic and steel—your reliable partner in any furniture installation.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-6.webp',
			'title' => 'Drilling Template for SERVO‑DRIVE Switch',
			'desc' => '<strong>BLUM Handheld Template for SERVO‑DRIVE Switches – Precision in every hole</strong>This precise handheld tool is ideal for accurate drilling of SERVO‑DRIVE actuator points, usable with manual drill or cordless driver. Suitable for components and assembled cabinets alike, it ensures fast and error‑free work. Durable aluminium design offers long‑term reliability in workshops and field use.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-2.webp',
			'title' => 'AVENTOS HK Top Marking Template',
			'desc' => '<strong>BLUM Front‑fastening Template – Accurate marking, simple assembly</strong>This template provides fast and reliable marking of fastening positions for front‑mount fittings. Its durable plastic/steel construction guarantees precision and longevity.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-1.webp',
			'title' => 'AVENTOS Product Line',
			'desc' => '<strong>AVENTOS Product Line – Innovative lift fittings for modern furniture</strong>AVENTOS is BLUM’s premium range of lift fittings that offer smooth, quiet, and safe operation for lift-up and pull-out furniture doors. They enhance usability and deliver a refined aesthetic. The latest addition, AVENTOS HKI, features a compact and slim design that fully integrates into the cabinet side wall—making the lift fitting virtually invisible. Ideal for minimalist furniture design with maximum design freedom and premium quality.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-7.webp',
			'title' => 'BLUM Lift Hinges',
			'desc' => '<strong>BLUM Lift Hinges – Precise fit and reliable function</strong>BLUM lift hinges are among the most popular furniture fittings, providing precise, durable, and easily adjustable closing action. With a wide range of types and options, there is a suitable solution for every furniture front and opening style. The modern onyx black variant adds exclusive design while maintaining quiet operation and long lifespan.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-16.webp',
			'title' => 'BLUM Drawer Systems',
			'desc' => '<strong>BLUM Drawer Systems – Precise engineering, easy assembly, long lifespan</strong>The MERIVOBOX robust construction simplifies assembly and offers long-term stability; TANDEMBOX provides quiet, smooth operation with fine adjustment; LEGRABOX offers clean, modern design and straightforward installation. Each system supports cabinet makers with ease of assembly and durability.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-1.webp',
			'title' => 'AMPEROS',
			'desc' => '<strong>AMPEROS – BLUM’s innovation revolutionising furniture lighting</strong>'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-blum-19.webp',
			'title' => 'REVEGO',
			'desc' => '<strong>BLUM REVEGO – Invisible solution, maximum impact</strong>REVEGO is a fully integrated pocket system that allows large fronts to slide aside into the cabinet in one motion. With factory-prepared components, installation and integration are fully supported. An innovative solution for cabinet makers seeking something truly exceptional.'
		),
	),

	'bramac_villas' => array(
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-bramac_villas-divoroll-standard.webp',
			'title' => 'Bramac Divoroll Standard Roofing Membrane',
			'desc' => 'Reliable, entry-level vapor-permeable roofing membrane with a new appearance and a weight of 120 g/m². Cost-effective solution with a 15-year warranty. Suitable for tile, slate, or ventilated profiled metal roofs, for both converted attics and cold roof structures.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-bramac_villas-divoroll-standardp.webp',
			'title' => 'Bramac Divoroll Standard+ Roofing Membrane',
			'desc' => 'Vapor-permeable roofing membrane that can be safely installed on solid boarding. Excellent value for money, high technical performance, and a 15-year warranty. Suitable for tile, slate, or ventilated profiled metal roofs, for both converted attics and cold roof structures. Its surface weight allows for installation on solid boarding.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-bramac_villas-divoroll-standardp-2s.webp',
			'title' => 'Bramac Divoroll Standard+ 2S Roofing Membrane',
			'desc' => 'An economical choice among vapor-permeable roofing membranes, offering excellent value for money and reliable technical features, with a 15-year warranty. Suitable for tile, slate, or ventilated profiled metal roofs, for both converted attics and cold roofs. The integrated double adhesive strip enables faster and safer installation, while also increasing water tightness at overlaps.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-bramac_villas-divoroll-duom-2s.webp',
			'title' => 'Bramac Divoroll DUO MAXIMUM 2S Roofing Membrane',
			'desc' => 'BMI’s new, uniquely developed underlay membrane for pitched roofs. Premium double protection with a surface weight of 200 g/m². The Duo means two waterproofing layers, combining the advantages of a weather-resistant monolithic top layer and an embedded microporous film, providing peace of mind for any roofing solution. The Duo Maximum membrane comes with a 30-year functional warranty, based on extensive rigorous and long-term real-world testing.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-bramac_villas-divoroll-hyper-2s.webp',
			'title' => 'Bramac Divoroll HYPER 2S Roofing Membrane',
			'desc' => 'Special reflective, vapor-permeable pitched roof underlay, combining a reinforced universal bottom layer with a metal-coated breathable film as a separate middle layer, which both reflects sunlight and cools the roof. This provides two main benefits: the metallized surface reduces the risk of membrane corrosion, and also reduces glare during installation, while lowering the temperature under the membrane by 2-3 degrees.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-bramac_villas-divoroll-topp-2s.webp',
			'title' => 'Bramac Divoroll TOP PLUS 2S Roofing Membrane',
			'desc' => 'Extra robust design, 230 g/m² surface weight, with special adhesive strip and mesh reinforcement. Bramac Divoroll Top Plus offers an effective solution for low-pitch and complex roofs. Its unique design, with an extra water-repellent, hydrophobized surface and a special double integrated adhesive strip at overlaps, prevents capillary water movement.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-bramac_villas-divoroll-kompaktp-2s.webp',
			'title' => 'Bramac Divoroll KOMPAKT+ 2S Roofing Membrane',
			'desc' => 'Robust roofing membrane with double adhesive strip, 145 g/m² weight. Suitable for tile, slate, or ventilated profiled metal roofs, both for converted attics and cold roofs. The integrated double adhesive strip enables faster installation.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-bramac_villas-divoroll-universalp-2s.webp',
			'title' => 'Bramac Divoroll UNIVERSAL PLUS 2S Roofing Membrane',
			'desc' => 'Reliable, 4-layer, increased surface weight membrane, ideal for professionals. Provides outstanding safety thanks to the extra strong reinforcement mesh and water-repellent, hydrophobized surface. The built-in double adhesive strip allows for faster and more efficient installation. The high-performance fleece offers enhanced protection against precipitation, while the integrated mesh reinforcement increases dimensional stability and resistance to stretching.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-bramac_villas-wakaflex.webp',
			'title' => 'Wakaflex Chimney and Wall Flashing',
			'desc' => 'With a 5m roll, any chimney flashing or wall connection can be quickly created on site with any roofing material—no tinsmith work required!'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-bramac_villas-figaroll.webp',
			'title' => 'FigaRoll Ridge Underlay',
			'desc' => 'Its side strip is stretchable by 50%, quickly and securely sealing the connection between roof tiles and ridge tiles, while providing highly effective ventilation with excellent water tightness.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-bramac_villas-icopal.webp',
			'title' => 'Icopal Universal WS POCB Waterproofing Membrane',
			'desc' => 'Suitable for both extensive and intensive green roofs in a single layer, enabling a more cost-effective and faster roofing solution. No need for torching the membrane, only the overlap needs to be welded. FLL certified.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-bramac_villas-termik.webp',
			'title' => 'TERMIK TOP 5 Speed SYNTAN® SBS Cap Sheet for Bitumen Roof Renovation with Vapor Channel',
			'desc' => 'Old bitumen roofs can be renovated in a single layer. No need for a felt underlay and cap sheet; vapor management and waterproofing can be completed in one step.'
		),
	),
	'butorvonal' => array(
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-butorvonal-hettich-avantech.webp',
			'title' => 'Hettich AvanTech YOU – with lighting',
			'desc' => 'The AvanTech YOU premium drawer system features an ultra-slim 13 mm side panel, concealed mechanism with precise adjustability, and a unique lighting solution. The LED profile lends the drawer a discreet, elegant appearance, while the system operates entirely wirelessly with a battery. The illuminated profile enhances the furniture’s aesthetic value, especially in the premium segment.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-butorvonal-hettich-furnspin.webp',
			'title' => 'Hettich FurnSpin',
			'desc' => 'FurnSpin is an innovative furniture movement solution that allows a cabinet front to rotate 180 degrees, giving cabinets new functionality and appearance. The system offers new possibilities especially for custom interior design and multifunctional space planning.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-butorvonal-hettich-topline.webp',
			'title' => 'TopLine and WingLine door systems',
			'desc' => 'In the field of sliding and folding doors, Hettich presents its reliable, well-known TopLine and WingLine systems in new configurations. TopLine is the ideal choice for large, modern sliding doors, while the WingLine folding system offers flexible solutions for small spaces, with outstanding stability and quiet operation.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-butorvonal-kessebohmer-freeslim.webp',
			'title' => 'Kesseböhmer FREEslim',
			'desc' => 'FREEslim is one of the world’s slimmest flap fittings, featuring a revolutionary 8 mm thick PowerPad mechanism for top cabinet opening. Its modular design allows customization for various opening types (drop-down, lift-up, bi-fold). Perfectly suited for minimalist kitchen and bathroom designs.',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-butorvonal-kessebohmer-chefstable.webp',
			'title' => 'Kesseböhmer ChefsTable',
			'desc' => 'ChefsTable is a professional kitchen accessory that enables ergonomic, rotating storage and easy access of larger appliances (e.g. stand mixers, coffee machines) from under the counter. This innovative solution significantly boosts kitchen workflow efficiency while providing sleek and practical storage.',
		),
	),


	'ceresit' => array(
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-ceresit-cn39.webp',
			'title' => 'Ceresit CN 39 floor levelling compound',
			'desc' => 'Fast-setting, cement-based levelling mortar with trass additive. Suitable for slope formation or vertical wall levelling. 3-30 mm layer thickness, crack-free result.',
			'more' => array(
				'href' => 'https://www.ceresit.hu/termekek/padloburkolas/aljzatkiegyenlites/aljzatkiegyenlito-egyeb/termekek.html/ceresit-cn-39/SAP_0201TCC013Y8.html',
				'title' => 'Ceresit CN 39 - Ceresit'
			)
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-ceresit-ce60.webp',
			'title' => 'Ready-to-use Ceresit CE 60 grout',
			'desc' => 'Polymer dispersion grout without water. Uniform color, durable result, no fading, ideal for interiors.',
			'more' => array(
				'href' => 'https://www.ceresit.hu/hu/innovaciok/ce60-hasznalatra-kesz-fuga.html',
				'title' => 'CE 60 The Ideal Ready-to-Use Grout - Ceresit'
			)
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-ceresit-9.webp',
			'title' => 'Ceresit façade cleaning system',
			'desc' => 'Removes urban and organic contaminants, algae, fungi. Preserves the aesthetic of the façade in the long term.',
			'more' => array(
				'href' => 'https://www.ceresit.hu/innovaciok/homlokzat-tisztitasa-es-felujitasa.html',
				'title' => 'Façade cleaning and renovation - Ceresit'
			)
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-ceresit-1.webp',
			'title' => 'Ceresit CL 51 brushable waterproofing foil',
			'desc' => 'Indoor waterproofing under ceramic coverings. ECO packaging, redesigned bucket, easier application with paint roller.',
			'more' => array(
				'href' => 'https://www.ceresit.hu/innovaciok/belteri-vizszigetelo-megoldas.html',
				'title' => 'Ceresit waterproofing solution - Ceresit'
			)
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-ceresit-3.webp',
			'title' => 'Ceresit CT 76 Solar Protect finishing render',
			'desc' => 'UV Protect technology, flexible and vapor-permeable finishing coat, low water absorption, high protection.',
			'more' => array(
				'href' => 'https://www.ceresit.hu/innovaciok/ceresit-ct-76---a-vakolat-vedelmezje.html',
				'title' => 'Ceresit CT 76 - The defender of render - Ceresit'
			)
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-ceresit-4.webp',
			'title' => 'Ceresit CT 77 mosaic plinth render',
			'desc' => '48 color shades, UV-resistant, also available in pre-mixed packaging. Premium mosaic render for modern needs.',
			'more' => array(
				'href' => 'https://www.ceresit.hu/innovaciok/mozaik-vakolat.html',
				'title' => 'New CT77, Premium mosaic render - Ceresit'
			)
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-ceresit-ct84.webp',
			'title' => 'Ceresit CT 84 Express PLUS adhesive foam',
			'desc' => 'PU adhesive foam for thermal insulation boards. Applicable above -10°C, for fast and efficient installation.',
			'more' => array(
				'href' => 'https://www.ceresit.hu/innovaciok/ceresit-ct-84-express-plus.html',
				'title' => 'Ceresit CT 84 Express Plus - Ceresit'
			)
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-ceresit-6.webp',
			'title' => 'Ceresit CF 850 and CF 920 chemical anchors',
			'desc' => 'Strong, styrene-free, two-component injection mortar. Ideal for heavy-load and edge-close fixings.',
			'more' => array(
				'href' => 'https://www.ceresit.hu/innovaciok/a-vegyi-dubel-ereje.html',
				'title' => 'The power of chemical anchors (CF 850, CF 920) - Ceresit'
			)
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-ceresit-7.webp',
			'title' => 'Ceresit CE 79 and CE 89 epoxy grouts',
			'desc' => 'Long-lasting colors, without efflorescence. High mechanical resistance, easy to apply and clean.',
			'more' => array(
				'href' => 'https://www.ceresit.hu/innovaciok/epoxy-fuga-forradalom.html',
				'title' => 'Epoxy Grout Revolution - Ceresit'
			)
		),
	),


	'festool' => array(
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-festool-dfc500.webp',
			'title' => 'DFC 500 Domino Joiner',
			'desc' => 'Cordless DOMINO joiner for precise fitting. Ergonomic design ensures stable joints from the very first dowel.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-festool-df500r.webp',
			'title' => 'DF 500 R DOMINO System',
			'desc' => 'DOMINO dowel system for various wood types. Expandable with accessories for indoor and outdoor use.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-festool-ofkc500.webp',
			'title' => 'OFKC 500 Edge Router',
			'desc' => 'Cordless edge router without tilting. Cable-free, precise, and stable routing in any situation.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-festool-ofk500.webp',
			'title' => 'OFK 500 Edge Router',
			'desc' => '0.1 mm height adjustment, precise edge processing. Clean results thanks to direct spindle design.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-festool-mfkc700.webp',
			'title' => 'MFKC 700 Cordless Modular Edge Router',
			'desc' => 'Interchangeable router tables: rounding, grooving, profiling – universal cordless edge router system.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-festool-mfkc700ka.webp',
			'title' => 'MFKC 700 KA Cordless Modular Edge Router',
			'desc' => 'Support table designed for protruding edges. Ideal for flush trimming, with ball bearing brake.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-festool-mfk700ka.webp',
			'title' => 'MFK 700 KA Modular Edge Router',
			'desc' => 'Handle-equipped router table support ensures optimal balance. Precise, tilt-free guidance.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-festool-hkc55.webp',
			'title' => 'HKC 55 Cordless Plunge Cut Circular Saw',
			'desc' => 'Powerful EC-TEC motor, long runtime with 8.0 Ah battery. Narrow blade for maximum performance.'
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-festool-hlc82.webp',
			'title' => 'HLC 82 Cordless Planer',
			'desc' => 'Strong EC-TEC motor, high pulling force and consistent performance even at maximum cutting depth.'
		),
	),



	'tesa' => array(

		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-tesa-74922.webp',
			'title' => 'tesa® 74922 - Self-adhesive protective paper',
			'desc' => 'Robust paper protection

<strong>Application</strong>
- Surface protection during renovation work: floors, stairs, windowsills
- Ideal on various surfaces: PVC, windows, and aluminum – NOT for use on natural stone!
- Protection of floors and high-traffic areas during renovations

<strong>Features</strong>
- Robust: backing made from 100% recycled fiber, FSC® certified paper (130 µm)
- Highly stable: 100% adhesive coverage
- Perfectly repositionable for up to one month
- Easily removable without residue: up to 3 months indoors
 [<a href="https://www.tesa.com/hu-hu/mesteremberek/tesa-74922-oentapado-vedopapir.html?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018" target="_blank">More information &rarr;</a>]
',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-tesa-74921.webp',
			'title' => 'tesa® 74921 - Self-adhesive protective film',
			'desc' => 'High-quality, large-area protective film

<strong>Application</strong>
- Protection on various surfaces: glass, PVC, PC, aluminum
- Furniture protection: prevents scratches and stains during transport and storage

<strong>Features</strong>
- Strong UV resistance: complies with EU standard ISO 4892-2-A
- Stretch film: stretchable up to 200% of its initial length
- Ideal for long-term construction: removable without residue for up to 6 months on outdoor glass, aluminum, and PVC (tear-free)
- Blue color: excellent visibility ensures precise protection
 [<a href="https://www.tesa.com/hu-hu/mesteremberek/tesa-74921-oentapado-vedofolia-ueveghez.html?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018" target="_blank">More information &rarr;</a>]
',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-tesa-04460.webp',
			'title' => 'tesa® 04460 - 2-in-1 Precision Masking Tape',
			'desc' => 'Efficient and time-saving masking method – for excellent painting results!

<strong>Application</strong>
Two layers of premium precision tape on one roll
For two applications in one step, e.g., sealing with decorator’s sealant or filler, followed by a coat of paint

<strong>Features</strong>
- Two layers of premium tesa® Precision Masking Tape on one roll
- tesa® “Washi” 4440 UV-resistant Precision Masking Tape as the bottom layer, for best painting results indoors and outdoors
- UV resistance up to 6 months: residue-free removal
- No discoloration on surfaces such as white PVC window frames
- tesa® “Washi” 4344 Color Separation Masking Tape as the top layer
- Thin yet robust paper backing for precise paint edges
- Easy removal of the top layer thanks to 1 mm paper offset
 [<a href="https://www.tesa.com/hu-hu/mesteremberek/tesa-professional-4460-2in1-precision-mask-szalag.html?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018" target="_blank">More information &rarr;</a>]
',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-tesa-4451.webp',
			'title' => 'tesa® Easy Cover Spray masking paper',
			'desc' => 'tesa® Easy Cover Spray 4451 offers a safe and reliable solution for spray-painting tasks using paint or lacquer, such as painting doorframes or skirting boards. Both edges of the Easy Cover 4451 are fitted with Washi masking tape for easy application and razor-sharp paint edges. This product can also be used to protect railings, balustrades, windowsills, doorframes, or skirting boards.
•	Ideal for painting doorframes or skirting boards
•	Quick masking of railings, balustrades, windowsills, or skirting boards
•	Even easier to use with a paint roller handle
Product features:
•	Double-sided adhesive tape for efficient and secure masking
•	Residue-free removal for up to 3 months indoors and 4 weeks outdoors
•	Size: 25m x 20 cm 
 [<a href="https://www.tesa.com/hu-hu/mesteremberek/tesa-professional-4451-easy-cover-precision-standard-spray-painting.html?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018" target="_blank">More information &rarr;</a>]
',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-tesa-74613.webp',
			'title' => 'tesa® PRO 74613 Duct Tape',
			'desc' => 'tesa PRO 74613 Duct Tape supports you in every job: water-repellent, easy to apply, and durable – this adhesive tape can be used on any surface. Extremely flexible and stronger than ever. Your new quick, reliable solution for almost any repair!
tesa PRO Duct Tape is ready for any use, indoors or outdoors.
It is water-repellent and works even on rough surfaces. This tape meets all professional needs: easy to tear and long-lasting, easy to unwind, and flexibly conforms to any base surface – ensuring optimal sealing.
This universal adhesive tape, with its strong adhesive strength, is ideal for temporary and permanent applications, repairs, marking, fastening, sealing, and packaging.
 [<a href="https://www.tesa.com/hu-hu/mesteremberek/tesa-pro-74613-duct-tape.html?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018" target="_blank">More information &rarr;</a>]
',
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-tesa-mounting-pro.webp',
			'title' => 'Mounting for PRO mounting tapes',
			'desc' => 'Professional adhesive tapes for reliable, fast, and clean drill-free mounting. Benefit from tesa’s expertise in double-sided tapes, used in demanding industries such as automotive, aerospace, and construction. Discover the new tesa® PRO Craftsmen range for complex mounting and bonding applications.
Reliable mounting and bonding tapes for all applications
- No drilling required – Mounting tapes for surfaces where holes are not acceptable
- Simple and fast application – our efficient mounting tapes help you save time
- Indoor or outdoor – various options available to meet all needs

Mounting objects has never been faster – no need for drilling or nails. No dust, no noise, no hassle!
 [<a href="https://www.tesa.com/hu-hu/mesteremberek/tesa-pro-szereloszalagok?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018" target="_blank">More information &rarr;</a>]
',
		),
	),
	'xella' => array(
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-xella-ytong.webp',
			'title' => 'Ytong staircase',
			'desc' => 'Endless creative possibilities, various design styles. Using Ytong prefabricated staircase elements during construction provides custom-made components tailored to the project, significantly reducing construction time and minimizing the required skilled labor.<br>Advantages:',
			'feats' => ['immediate load-bearing capacity', 'lightweight and fast installation, no need for formwork or temporary support', 'solution adapted to site conditions', 'can be installed simultaneously with masonry or later', 'cost-effective structure', 'minimal moisture input during construction', 'safe, excellent fire resistance'],
			'more' => ['title' => 'More', 'href' => 'https://www.xella.hu/hu_HU/Lepcso']
		),
		array(
			'file' => 'https://www.homeinfo.hu/emw/assets/ujdonsagok-xella-multipor.webp',
			'title' => 'Multipor mineral insulation',
			'desc' => 'Multipor is a stable, mineral crystal-structured insulation board offering a new alternative to traditional fiber or plastic foam insulations. Its alkaline pH naturally prevents mold and mildew growth. Manufactured using environmentally conscious technology and mineral raw materials (sand, lime, water).<br>Advantages:',
			'feats' => ['excellent thermal insulation', 'non-combustible (A1 fire rating)', 'high vapor permeability', 'wide application range (external, internal, soffit insulation)', 'easy to cut and shape to size', 'solid, homogeneous structure', 'sound-absorbing – does not reduce wall acoustic performance', 'impregnated, water-repellent', 'resistant to pests (insects, rodents)'],
			'more' => ['title' => 'More', 'href' => 'https://www.multipor.hu/hu_HU/']
		),

	),
);
$cikkek = array(
	'butorvonal' => array(
		array(
			'id' => 'butorvonal-okos-tarolomegoldas',
			'title' => 'Okos tárolómegoldások: Nagyobb eladások és elégedettebb ügyfelek konyhánként',
		),
		array(
			'id' => 'butorvonal-hettich-kivetopantok',
			'title' => 'A Kesseböhmer LeMans: Innovatív megoldás konyhai sarokszekrényekhez',
		),
		array(
			'id' => 'butorvonal-kessebohmer-lemans',
			'title' => 'Hettich kivetőpántok: A bútorok láthatatlan hősei, amelyek megkönnyítik a mindennapokat',
		),

	),
	/*'baumit' => array(
		array(
			'id' => 'all-in-beton-b20',
			'title' => 'All In Beton B20',
		),
		array(
			'id' => 'baumacol-flexuni-gel',
			'title' => 'Baumacol FlexUni Gel',
		),
		array(
			'id' => 'baumit-gel-technologias-ragasztotapaszok',
			'title' => 'Baumit gél-technológiás ragasztótapaszok',
		),
		array(
			'id' => 'baumit-starttop-vekonyvakolat',
			'title' => 'Baumit StartTop vékonyvakolat',
		),
		array(
			'id' => 'termeszetes-lakoklima-ionit',
			'title' => 'Természetes Lakóklíma, Ionit',
		),
		array(
			'id' => 'baumit-sanova-felujito-vakolatok',
			'title' => 'Baumit Sanova felújító vakolatok alkalmazása nedves és sóterhelt falazatok esetén',
		),
	),*/
	'ceresit' => array(
		array(
			'id' => 'ceresit-megjelent-az-uj-ceresit-cn-39',
			'title' => 'Megjelent az új Ceresit CN 39',
		),
		array(
			'id' => 'ceresit-120-eves-a-ceresit',
			'title' => '120 éves a Ceresit – Játsszon és nyerje meg a havi nyeremények egyikét!',
		),
		array(
			'id' => 'homlokzat-tisztitasa-es-felujitasa-ceresit-termekekkel',
			'title' => 'Homlokzat tisztítása és felújítása Ceresit termékekkel',
		),
		array(
			'id' => 'ceresit-cs-25-express-uj-gyorskotesu-szilikon-szaniter-tomitesekhez',
			'title' => 'Ceresit CS 25 EXPRESS – Új, gyorskötésű szilikon szaniter tömítésekhez',
		),
		// array(
		// 'id' => 'ceresit-ce-40-flexibilis-fugazoanyag',
		// 'title' => 'Ceresit CE 40 flexibilis fugázóanyag innovatív technológiával és új formulával',
		// ),
		array(
			'id' => 'ceresit-visage-vakolatok',
			'title' => 'Ceresit Visage vakolatok – A kivételes homlokzatért',
		),
		// array(
		// 'id' => 'ceresit-hidegburkolasi-rendszer-segedlet',
		// 'title' => 'Új segédlet a komplett Ceresit hidegburkolási rendszerhez',
		// ),
		array(
			'id' => 'nagymeretu-burkololapok-telepitese',
			'title' => 'Nagyméretű burkolólapok telepítése – Ceresit termékajánló',
		),
		array(
			'id' => 'ceresit-ct-76-fedovakolat',
			'title' => 'Ceresit CT 76 fedővakolat homlokzata védelmére',
		),
		array(
			'id' => 'ceresit-ce-60-fugazo',
			'title' => 'Új Ceresit CE 60 felhasználásra kész fugázó',
		),
		array(
			'id' => 'ceresit-mozaikvakolatok',
			'title' => 'A Ceresit mozaikvakolatok megújult választéka',
		),
		array(
			'id' => 'homlokzati-szintrendek-a-ceresittol',
			'title' => 'Homlokzati színtrendek a Ceresittől',
		),

	),
	'fatraizolfa' => array(
		// array(
		// 'id' => 'energetikai-felujitas-a-vizszigetelo-szemevel',
		// 'title' => 'Energetikai felújítás a vízszigetelő szemével',
		// ),
		// array(
		// 'id' => 'fatrafol-kritikus-csomopont-nagyito-alatt',
		// 'title' => 'FATRAFOL – Kritikus csomópont nagyító alatt',
		// ),
		// array(
		// 'id' => 'uj-idok-uj-igenyek-melegpadlok-a-fatra-gondozasaban',
		// 'title' => 'Új idők új igények – Melegpadlók a Fatra gondozásában',
		// ),
		// array(
		// 'id' => 'fatrafol-darazsfeszek-a-csempe-alatt',
		// 'title' => 'FATRAFOL – Darázsfészek a csempe alatt ',
		// ),	
		array(
			'id' => 'fatrafloor-thermofix-pro-egy-padlo-ami-kitart',
			'title' => 'Fatrafloor Thermofix PRO - Egy padló, ami kitart',
		),
		array(
			'id' => 'az-egeszseges-kornyezet-a-labunk-alatt-kezdodik',
			'title' => 'Az egészséges környezet a lábunk alatt kezdődik',
		),
		array(
			'id' => 'ut-a-jobb-padlohoz',
			'title' => 'Út a jobb padlóhoz',
		),
		array(
			'id' => 'fatrafol-h-alepitmeny-szigeteles-egy-kis-extraval',
			'title' => 'Fatrafol H alépítmény szigetelés egy kis extrával',
		),
		array(
			'id' => 'nem-lutri-a-szigeteles',
			'title' => 'Nem lutri a szigetelés',
		),
		array(
			'id' => 'a-terasz-szigeteles-up-to-date',
			'title' => 'A terasz szigetelés Up-to-date',
		),
	),/*
'klimaexpress' => array(
  array(
	  'id' => 'snickers-nadragok-szerszamtartoval-terdvedelemmel',
	  'title' => 'Snickers nadrágok, szerszámtartóval, térdvédelemmel',
  ),
  array(
	  'id' => 'hidegebb-idoben-is-idealis-munkaruhazat',
	  'title' => 'Hidegebb időben is ideális munkaruházat',
  ),
  array(
	  'id' => 'munkavedelmi-eszkozok',
	  'title' => 'Munkavédelmi eszközök',
  ),
  array(
	  'id' => 'snickers-workwear-top-sales',
	  'title' => 'A legkedveltebb ruhadarabok az igényes Snickers Workwear-től',
  ),
  array(
	  'id' => 'munkavedelmi-cipok',
	  'title' => 'Munkavédelmi cipők',
  ),
),*/
);

$cikkek_en = array(
	'butorvonal' => array(
		array(
			'id' => 'butorvonal-okos-tarolomegoldas',
			'title' => 'Smart Storage Solutions: Higher Sales and More Satisfied Customers per Kitchen',
		),
		array(
			'id' => 'butorvonal-hettich-kivetopantok',
			'title' => 'Kesseböhmer LeMans: Innovative Solution for Corner Kitchen Cabinets',
		),
		array(
			'id' => 'butorvonal-kessebohmer-lemans',
			'title' => 'Hettich Hinges: The Invisible Heroes of Furniture that Make Everyday Life Easier',
		),
	),
	/*'baumit' => array(
		array(
			'id' => 'all-in-beton-b20',
			'title' => 'All In Concrete B20',
		),
		array(
			'id' => 'baumacol-flexuni-gel',
			'title' => 'Baumacol FlexUni Gel',
		),
		array(
			'id' => 'baumit-gel-technologias-ragasztotapaszok',
			'title' => 'Baumit Gel Technology Adhesive Mortars',
		),
		array(
			'id' => 'baumit-starttop-vekonyvakolat',
			'title' => 'Baumit StartTop Thin Plaster',
		),
		array(
			'id' => 'termeszetes-lakoklima-ionit',
			'title' => 'Natural Indoor Climate, Ionit',
		),
		array(
			'id' => 'baumit-sanova-felujito-vakolatok',
			'title' => 'Baumit Sanova Renovation Plasters for Damp and Salt-Loaded Walls',
		),
	),*/
	'ceresit' => array(
		array(
			'id' => 'ceresit-megjelent-az-uj-ceresit-cn-39',
			'title' => 'The New Ceresit CN 39 Has Arrived',
		),
		array(
			'id' => 'ceresit-120-eves-a-ceresit',
			'title' => 'Ceresit Turns 120 – Play and Win One of the Monthly Prizes!',
		),
		array(
			'id' => 'homlokzat-tisztitasa-es-felujitasa-ceresit-termekekkel',
			'title' => 'Facade Cleaning and Renovation with Ceresit Products',
		),
		array(
			'id' => 'ceresit-cs-25-express-uj-gyorskotesu-szilikon-szaniter-tomitesekhez',
			'title' => 'Ceresit CS 25 EXPRESS – New Fast-Curing Silicone for Sanitary Sealing',
		),
		// array(
		// 'id' => 'ceresit-ce-40-flexibilis-fugazoanyag',
		// 'title' => 'Ceresit CE 40 Flexible Grout with Innovative Technology and New Formula',
		// ),
		array(
			'id' => 'ceresit-visage-vakolatok',
			'title' => 'Ceresit Visage Plasters – For Exceptional Facades',
		),
		// array(
		// 'id' => 'ceresit-hidegburkolasi-rendszer-segedlet',
		// 'title' => 'New Guide for the Complete Ceresit Cold Tiling System',
		// ),
		array(
			'id' => 'nagymeretu-burkololapok-telepitese',
			'title' => 'Installing Large-Format Tiles – Ceresit Product Recommendations',
		),
		array(
			'id' => 'ceresit-ct-76-fedovakolat',
			'title' => 'Ceresit CT 76 Top Coat for Facade Protection',
		),
		array(
			'id' => 'ceresit-ce-60-fugazo',
			'title' => 'New Ceresit CE 60 Ready-to-Use Grout',
		),
		array(
			'id' => 'ceresit-mozaikvakolatok',
			'title' => 'The Renewed Range of Ceresit Mosaic Plasters',
		),
		array(
			'id' => 'homlokzati-szintrendek-a-ceresittol',
			'title' => 'Facade Color Trends from Ceresit',
		),
	),
	'fatraizolfa' => array(
		array(
			'id' => 'fatrafloor-thermofix-pro-egy-padlo-ami-kitart',
			'title' => 'Fatrafloor Thermofix PRO – A Floor That Lasts',
		),
		array(
			'id' => 'az-egeszseges-kornyezet-a-labunk-alatt-kezdodik',
			'title' => 'A Healthy Environment Starts Beneath Our Feet',
		),
		array(
			'id' => 'ut-a-jobb-padlohoz',
			'title' => 'The Path to Better Flooring',
		),
		array(
			'id' => 'fatrafol-h-alepitmeny-szigeteles-egy-kis-extraval',
			'title' => 'Fatrafol H Foundation Waterproofing with a Little Extra',
		),
		array(
			'id' => 'nem-lutri-a-szigeteles',
			'title' => 'Waterproofing Is No Gamble',
		),
		array(
			'id' => 'a-terasz-szigeteles-up-to-date',
			'title' => 'Terrace Waterproofing Up-to-Date',
		),
	),
	/*
'klimaexpress' => array(
	array(
		'id' => 'snickers-nadragok-szerszamtartoval-terdvedelemmel',
		'title' => 'Snickers Trousers with Tool Holders and Knee Protection',
	),
	array(
		'id' => 'hidegebb-idoben-is-idealis-munkaruhazat',
		'title' => 'Ideal Workwear for Colder Weather',
	),
	array(
		'id' => 'munkavedelmi-eszkozok',
		'title' => 'Protective Equipment',
	),
	array(
		'id' => 'snickers-workwear-top-sales',
		'title' => 'Top-Picked Clothing Items from Snickers Workwear',
	),
	array(
		'id' => 'munkavedelmi-cipok',
		'title' => 'Safety Footwear',
	),
),*/
);


$cikkekCegek = array_keys($cikkek);

$cikkekHomeinfon = array(
	/*
		'aco' => array(

			array(
				'title' => 'ACO Therm angolaknák',
				'thumb' => 'https://www.homeinfo.hu/emw/files/aco/cikk-1.webp',
				'url' => 'https://www.aco.hu/termekek/angolaknak-es-pincei-ablakok/m%C5%B1anyag-angolakn%C3%A1k?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018',
			),
			array(
				'title' => 'Az ACO megoldásai a teraszok, erkélyek és homlokzatok vízelvezetésére',
				'thumb' => 'https://www.homeinfo.hu/emw/files/aco/cikk-2.webp',
				'url' => 'https://www.aco.hu/alkalmazasok/teraszok-erkelyek-homlokzatok-viztelenitese?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018',
			),
			array(
				'title' => 'ACO Slimline: elegancia a kültéri vízelvezetésben',
				'thumb' => 'https://www.homeinfo.hu/emw/files/aco/cikk-3.webp',
				'url' => 'https://www.aco.hu/slimline?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018',
			),
			array(
				'title' => 'ACO Vario 2.0 beépíthető kül- és beltéri lábtörlő rendszerek',
				'thumb' => 'https://www.homeinfo.hu/emw/files/aco/cikk-4.webp',
				'url' => 'https://www.aco.hu/labtorlok?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018',
			),
		),
		'knaufinsulation' => array(
			array(
				'title' => 'Tetőszigeteléssel 25 százalékkal is csökkenthetjük családi házunk hőveszteségét',
				'thumb' => 'https://www.homeinfo.hu/images/stories/cikkek/knauf/2018-03-26/420x210.jpg',
				'url' => 'https://www.homeinfo.hu/epitkezes-felujitas/szigeteles/2114-tetoszigetelessel-25-szazalekkal-is-csokkenthetjuk-csaladi-hazunk-hoveszteseget',
			),
			array(
				'title' => 'Tévhitek a hőszigeteléssel kapcsolatban',
				'thumb' => 'https://www.homeinfo.hu/images/stories/cikkek/knauf/2018-05-23/420x210.jpg',
				'url' => 'https://www.homeinfo.hu/epitkezes-felujitas/szigeteles/1169-tevhitek-a-hoszigetelessel-kapcsolatban',
			),
			array(
				'title' => 'Drágábban adható el a hőszigetelt ingatlan',
				'thumb' => 'https://www.homeinfo.hu//images/stories/cikkek/knauf/2021-03-09/420x210.jpg',
				'url' => 'https://www.homeinfo.hu/hirek/2227-dragabban-adhato-el-a-hoszigetelt-ingatlan',
			),
			array(
				'title' => 'Akár egy nap alatt 25%-kal csökkenthetjük fűtési költségeinket',
				'thumb' => 'https://www.homeinfo.hu/images/stories/cikkek/knauf/2021-10-26/420x210.jpg',
				'url' => 'https://www.homeinfo.hu/epitkezes-felujitas/szigeteles/hoszigeteles/3282-akar-egy-nap-alatt-25-kal-csokkenthetjuk-futesi-koltsegeinket',
			),
			array(
				'title' => 'Homlokzati hőszigetelés kőzetgyapottal – Miért válasszunk kőzetgyapot termékeket?',
				'thumb' => 'https://www.homeinfo.hu/images/stories/cikkek/knauf/2021-03-28/420x210.jpg',
				'url' => 'https://www.homeinfo.hu/epitkezes-felujitas/szigeteles/hoszigeteles/3161-homlokzati-hoszigeteles-kozetgyapottal-miert-valasszunk-kozetgyapot-termekeket',
			),
			array(
				'title' => 'Megfelelő hangszigeteléssel csökkenthető otthonaink zajszintje',
				'thumb' => 'https://www.homeinfo.hu/images/stories/cikkek/knauf/2018-07-24/420x210.jpg',
				'url' => 'https://www.homeinfo.hu/epitkezes-felujitas/szigeteles/2577-megfelelo-hangszigetelessel-csokkentheto-otthonaink-zajszintje',
			),
			array(
				'title' => 'Fújható ásványgyapot szigetelés',
				'thumb' => 'https://www.homeinfo.hu/images/stories/videok/knauf/2017-09-20/gpFBBCrGXfo-420x210.jpg',
				'url' => 'https://www.homeinfo.hu/video/2328-fujhato-asvanygyapot-szigeteles',
			),
		),
		'krause' => array(
			array(
				'title' => 'Új egy és két oldalon járható lépcsőfokos teleszkópos KRAUSE létrák',
				'thumb' => 'https://www.krause-systems.hu/fileadmin/user_upload/News/2024/Neue_KRAUSE_Teleskop-Stufenl.eiternjpg.jpg',
				'url' => 'https://www.krause-systems.hu/ceguenkrol/aktualis/detail/uj-egy-es-ket-oldalon-jarhato-lepcsofokos-teleszkopos-krause-letrak.html?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018',
			),
			array(
				'title' => 'Új animált KRAUSE technikai videók a ProTec gurulóállványok gyors összeszereléséhez',
				'thumb' => 'https://www.krause-systems.hu/fileadmin/user_upload/News/2024/KRAUSE_ProTec_1000_FahrGeruest_in_Anwendung.jpg',
				'url' => 'https://www.krause-systems.hu/ceguenkrol/aktualis/detail/neue-animierte-krause-technik-clips-zum-schnellen-aufbau-der-fahrgeruest-serie-protec-2.html?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018',
			),
			array(
				'title' => 'A KRAUSE új, 225 kg terhelhetőségű létrákkal bővítette létra szortimentjét',
				'thumb' => 'https://www.krause-systems.hu/fileadmin/user_upload/News/2023/KRAUSE_225kg_Belastbarkeit.jpg',
				'url' => 'https://www.krause-systems.hu/ceguenkrol/aktualis/detail/a-krause-uj-225-kg-terhelhetosegu-letrakkal-bovitette-letra-szortimentjet.html?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018',
			),
			array(
				'title' => 'A KRAUSE csúszásmentes R13 lépcsőfokos dobogókkal bővítette termékkínálatát',
				'thumb' => 'https://www.krause-systems.hu/fileadmin/_processed_/1/2/csm_KRAUSE-StufenDoppelLeiter_R13_d60c4c3ddc.jpg',
				'url' => 'https://www.krause-systems.hu/ceguenkrol/aktualis/detail/a-krause-r13-lepcsofokos-alloletrakkal-bovitette-termekpalettajat.html?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018',
			),
			array(
				'title' => 'A KRAUSE csúszásmentes R13 lépcsőfokos dobogókkal bővítette termékkínálatát',
				'thumb' => 'https://www.krause-systems.hu/fileadmin/user_upload/News/2023/KRAUSE_Podestleitern_2023.jpg',
				'url' => 'https://www.krause-systems.hu/ceguenkrol/aktualis/detail/krause-ueberarbeitet-podestleitern-und-erweitert-das-programm-um-stufen-mit-rutschhemmung-r13-2.html?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018',
			),
		),


		'leier' => array(
			array(
				'title' => 'Leier Kerítéskő',
				'thumb' => 'https://www.homeinfo.hu/emw/files/leier/homeinfo-bannerek-keritesko.webp',
				'url' => 'https://www.leier.hu/hu/termekeink/keriteskovek-fedlapok?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018',
			),
			array(
				'title' => 'Leier Térkő',
				'thumb' => 'https://www.homeinfo.hu/emw/files/leier/homeinfo-bannerek-terko-es-kerti-lap.webp',
				'url' => [
					'Leier Térkő' => 'https://www.leier.hu/hu/termekeink/terburkolo-kovek?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018',
					'Leier Burkolólapok' => 'https://www.leier.hu/hu/termekeink/burkololapok?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018',
				],
			),
			array(
				'title' => 'Leier Kémény',
				'thumb' => 'https://www.homeinfo.hu/emw/files/leier/homeinfo-bannerek-kemeny.webp',
				'url' => 'https://kemenyshop.leier.hu/hu?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018',
			),
			array(
				'title' => 'Leier Betoncserép',
				'thumb' => 'https://www.homeinfo.hu/emw/files/leier/homeinfo-bannerek-betoncserep.webp',
				'url' => 'https://www.leier.hu/hu/termekeink/betoncserepek?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018',
			),
			array(
				'title' => 'Leier Tégla',
				'thumb' => 'https://www.homeinfo.hu/emw/files/leier/homeinfo-bannerek-tegla-es-athidalo.webp',
				'url' => [
					'LeierPlan Tégla' => 'https://www.leier.hu/hu/termekeink/egetett-keramia-falazoelemek?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018',
					'Leier Nyílásáthidaló' => 'https://www.leier.hu/hu/termekeink/nyilasathidalok?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018',
				],
			),

		),
		'wattbolt' => array(
			array(
				'title' => 'AABoard',
				'thumb' => 'https://www.homeinfo.hu/emw/files/wattbolt/aaboard.webp',
				'url' => 'https://www.wattbolt.com/Epuletautomatika?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018',
			),
			array(
				'title' => 'Akkumulátor',
				'thumb' => 'https://www.homeinfo.hu/emw/files/wattbolt/akkumulator.webp',
				'url' => 'https://www.wattbolt.com/spl/306095/Akkumulator?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018',
			),
			array(
				'title' => 'Elektromos autótöltő',
				'thumb' => 'https://www.homeinfo.hu/emw/files/wattbolt/elektromos-autotolto.webp',
				'url' => 'https://www.wattbolt.com/shop_search.php?search=go-e&infinite_page=3&utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018',
			),
			array(
				'title' => 'Elektromos gép adapterek',
				'thumb' => 'https://www.homeinfo.hu/emw/files/wattbolt/elektromos-adapterek.webp',
				'url' => 'https://www.wattbolt.com/Munkagep-kiegeszitok?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018',
			),
			array(
				'title' => 'Inverter',
				'thumb' => 'https://www.homeinfo.hu/emw/files/wattbolt/inverter.webp',
				'url' => 'https://www.wattbolt.com/Inverter-es-kiegeszitok?infinite_page=2&utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018',
			),
			array(
				'title' => 'WL04E Elektromos rakodó',
				'thumb' => 'https://www.homeinfo.hu/emw/files/wattbolt/wl04e.webp',
				'url' => 'https://www.wattbolt.com/WATT-WL04E-elektromos-rakodo?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018',
			),
			array(
				'title' => 'WL06E Elektromos rakodó',
				'thumb' => 'https://www.homeinfo.hu/emw/files/wattbolt/wl06e.webp',
				'url' => 'https://www.wattbolt.com/WATT-WL06E-elektromos-rakodo?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018',
			),
		),
		'meton' => array(
			array(
				'title' => 'Meton Texturato és Next Silicon szálerősített díszvakolatok',
				'thumb' => 'https://meton.hu/wp-content/uploads/2023/10/istock-697705528-1-397x280.jpg',
				'url' => 'https://meton.hu/hirek/szalerositett_diszvakolatok?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018',
			),
			array(
				'title' => 'A színek hatása otthonunkban 1.',
				'thumb' => 'https://meton.hu/wp-content/uploads/2024/06/istock-509365378-atalakitott-01-397x280.jpg',
				'url' => 'https://meton.hu/hirek/a-szinek-hatasa-otthonunkban-1?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018',
			),
			array(
				'title' => 'A színek hatása otthonunkban 2.',
				'thumb' => 'https://meton.hu/wp-content/uploads/2024/07/istock-1207261035-1-397x280.jpg',
				'url' => 'https://meton.hu/hirek/a-szinek-hatasa-otthonunkban-2?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018',
			),
			array(
				'title' => 'Az alga elleni védelem fontossága homlokzati hőszigetelő rendszerekben',
				'thumb' => 'https://meton.hu/wp-content/uploads/2024/08/ars-pajzs-masolat-2-397x280.jpg',
				'url' => 'https://meton.hu/hirek/az-alga-elleni-vedelem-fontossaga-homlokzati-hoszigetelo-rendszerekben?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018',
			),
		),

		'innopan' => array(
			array(
				'title' => 'Ismerd meg az Innopan PIR termékeket!',
				'thumb' => 'https://www.homeinfo.hu/emw/files/innopan/termekek.webp',
				'url' => 'https://innopan.hu/hu/termekek?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018',
			),
			array(
				'title' => 'PIR, a legkorszerűbb hőszigetelő anyag:',
				'thumb' => 'https://www.homeinfo.hu/emw/files/innopan/megoldasaink.webp',
				'url' => 'https://innopan.hu/hu/megoldasaink?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018',
			),
		),
		'trilak' => array(
			array(
				'title' => 'Megjelent az új Héra Beltéri Falfesték',
				'thumb' => 'https://www.homeinfo.hu/emw/files/trilak/hera-belteri-falfestek.webp',
				'url' => 'https://trilakfestekstudio.hu/tartalom/termekismertetok/hera-belteri-falfestek?utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018',
			),
		),*/
	'xella' => array(
		array(
			'title' => '5 ok, amiért érdemes az Ytong lépcsőelem beépítését fontolóra venni',
			'thumb' => 'https://www.homeinfo.hu/images/stories/cikkek/xella/2024-05-03/420x210.webp',
			'url' => 'https://www.homeinfo.hu/epitkezes-felujitas/szerkezet/3696-5-ok-amiert-erdemes-az-ytong-lepcsoelem-beepiteset-fontolora-venni',
		),
		array(
			'title' => 'Multipor: fenntartható és hatékony megoldás otthona hőszigetelésére',
			'thumb' => 'https://www.homeinfo.hu/images/stories/cikkek/xella/2025-05-08/420x210.webp',
			'url' => 'https://www.homeinfo.hu/epitkezes-felujitas/szigeteles/hoszigeteles/3820-multipor-fenntarthato-es-hatekony-megoldas-otthona-hoszigetelesere',
		),
	),


);

$videok = array(
	'dufa' => ['A27hwT6PtNI'],


	'blum' => ['vnYsejwgPeM','VF6tnjy4Mj8','179UlRT4-ME','8XEGkAyhaoM','cHjGMzsHeew','RU034mXX61A','S5vZnK2wzwE','a6STneR6_yk'],
	'anda' => ['KvV7zWLPCWY'],
	'knaufinsulation' => ['G592HAfusbg', '_hDJvJEGwes', 'VX51ZTeCUa4'],
	'krause' => ['DYCuevUh-HU'/*,'Nz3RzKZSXe4', 'w2C5g_I5s-Q'*/],
	'helios' => ['MEoDFKQyhwo', 'wnpu719oP50', 'HzTfZiiET2g', 'zU0810t4tjg', 'KZWlpBaSeS0', 'HwlJMB8jssc'],
	'innopan' => ['59By-WdN-fc', 'qk03Lyr_r-w', 'vbEDiuWKu8c', '8OanqBix7PE'],
	'recycolor' => ['8JL0q0V9LIw', 'FWY4SKyII9M', 'W3E-dd2wswQ', 'IZ7CvzjXrMw', 'C-0P4DrluTs', 'FNFXbb2rct4', 'gFtemNsduVc', 'pPZI7MwW23w', 'y8n4pw5BTY4', 'GQW-3j3cVzU', 'svvFYq19yBM', 'X_d0Knk3urQ'],
	'turbosol' => ['jK2bJNSP9EA', 'aX1-fNtq39s', 'n5gUERgRPsM'],

	'zakanyszerszam' => ['BPrANGbAVDA'],
	'terran' => ['TCHsDspWqmw'],
	'sika' => ['97H1ca6325c'],
	'soudal' => ['mS5NvKInGN4'],
	'meton' => ['lFfC0eFlQoo', 'FmhRPVtU8LM', 'i0x6xNk56-U', 'qFtnHXrS0vc', 'rMUfux7s95M', 'sqia6punv_k', 'vE4XGmiwXi8'],
	'klimaexpress' => ['p1VqVTcTi0I', 'BqH2lbglWxc', 'iLqOS5O1vnQ', '3Slp1wyzB38', 'psuW3AKo4WE', 'TmtJQrh8iuo', 'xNN5zjkOijU', 'aK07WtNAl3A', 's6oD0JEBSdc'],
	'atlas' => ['z5DBGrwbwfg', '4vcMnA-4Clg', 'wbrCdhEOzew', 's-VKVu1Uc7Y', '7K6zkeoFNgg', 'nYyWXIcOt2I'],
	'tesa' => ['2ggKiPkotjE', 'Au-__NoVNI0', 'qqPa4N0prXU', '1rEbRi86Bl4', 'al99ZOlVKXY'],
	'mofem' => ['Lbo-M9BFERM&t=4s','e8zRDj8z3MI&t=2s','Zxg3q6oyV1I&t=1s','FQ9Qd8UFYHk&t=4s']
);



$gallery = array(
	'mofem' => 5,
	'butorvonal' => 19,
	'anda' => 4,
	'ceresit' => 9,
	'helios' => 7,
	'krause' => 9,
	'sshterra' => 5,
	'xella' => array(
		'https://www.homeinfo.hu/images/stories/cikkek/xella/2025-05-08/1-xella-multipor-asvanyi-hoszigetelo-lap-480w.webp',
		'https://www.homeinfo.hu/images/stories/cikkek/xella/2025-05-08/2-xella-multipor-asvanyi-hoszigetelo-lap-480w.webp',
		'https://www.homeinfo.hu/images/stories/cikkek/xella/2025-05-08/3-xella-multipor-asvanyi-hoszigetelo-lap-480w.webp',
		'https://www.homeinfo.hu/images/stories/cikkek/xella/2025-05-08/4-xella-multipor-asvanyi-hoszigetelo-lap-480w.webp',
		'https://www.homeinfo.hu/images/stories/cikkek/xella/2024-05-03/1-ytong-lepcsoelem-480w.webp',
		'https://www.homeinfo.hu/images/stories/cikkek/xella/2024-05-03/2-ytong-lepcsoelem-480w.webp',
		'https://www.homeinfo.hu/images/stories/cikkek/xella/2024-05-03/3-ytong-lepcsoelem-480w.webp',
		'https://www.homeinfo.hu/images/stories/cikkek/xella/2024-05-03/4-ytong-lepcsoelem-480w.webp',
	),
);

$bwgallery = array(
	'https://static.homeinfo.hu/cache/80af827e8bfbf9476b4a4f03737ed2311a250665.jpg',
	'https://static.homeinfo.hu/cache/46c1d7b410ae020e4e6112e05fc65e6bf63413a7.jpg',
	'https://static.homeinfo.hu/cache/b17973cfea050a8e2473bcd876a9def342b4f01d.jpg',
	'https://static.homeinfo.hu/cache/67028c0fb22fbcb7b37dd471619b1403f4da91ed.jpg',
	'https://static.homeinfo.hu/cache/36a7ae1fd6b463e9a262dbb159906d072fb47465.jpg',
	'https://static.homeinfo.hu/cache/4854ef8cbb3b8662dac1331ce1ee5250d1e28afd.jpg',
	'https://static.homeinfo.hu/cache/2e6f98be5fc7f4eb24c0c89fd87a290669bb6a9b.jpg',
	'https://static.homeinfo.hu/cache/891e5d1b58cd6733cbe81e60f4774b351d2d5461.jpg',
	'https://static.homeinfo.hu/cache/50accc8c17409480e5f515e0b5d23c6f13460d3a.jpg',
	'https://static.homeinfo.hu/cache/ce309e137c229900c8a59b335f2a487b0ae40c41.jpg',
	'https://static.homeinfo.hu/cache/9419ef770e0962f2cb4e5bfed1e333ecbbcaa57d.jpg',
	'https://static.homeinfo.hu/cache/7c781bd3871a8064def88a97f812bcd58b64aa64.jpg',
	'https://static.homeinfo.hu/cache/963d23df8763aaaf267aaf0d4ead0258f1ddffa6.jpg',

);


$tiktokkers = array();
$tiktokkers[] = array('img' => '4', 'link' => 'https://www.tiktok.com/@keritesdoki2.0official', 'tiktok' => 'keritesdoki2.0official', 'name' => 'AKeritès Doki');
$tiktokkers[] = array('img' => 'burkololany', 'tiktok' => 'https://www.tiktok.com/@burkololany', 'tiktok' => 'burkololany', 'name' => 'Burkoló Lány ®');
$tiktokkers[] = array('img' => '2', 'tiktok' => 'https://www.tiktok.com/@dedy86burkolo', 'tiktok' => 'dedy86burkolo', 'name' => 'Dedy');
$tiktokkers[] = array('img' => '6', 'link' => 'https://www.tiktok.com/@sefatias', 'tiktok' => 'sefatias', 'name' => 'Kovács István');
$tiktokkers[] = array('img' => 'szakiellenor', 'link' => 'https://www.youtube.com/@SzakiEllenor', 'tiktok' => 'SzakiEllenor', 'name' => 'Rezsnyák Péter');

if (!function_exists('withUTM')) {
	function withUTM($link)
	{
		$link = trim($link);

		if (strpos($link, 'www.vipvitaportal.hu') !== FALSE) // nem tölt be a weboldaluk több querystringgel
			return $link . '?utm_source=homeinfo';

		$param = 'utm_source=homeinfo&utm_medium=emw&utm_campaign=emw-20251018';

		$hashstring = '';
		if (strpos($link, '#') !== FALSE) {
			list($link, $hashstring) = explode('#', $link);
			$hashstring = '#' . $hashstring;
		}

		$glue = (strpos($link, '?') === FALSE) ? '?' : '&';

		return $link . $glue . $param . $hashstring;
	}
}
